###############################################################################
#  gen_nca_size_tabel.py: Module for PATTERN MATCH
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Vlastimil Kosar <ikosar@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

import commands
import sys
import nfa_split
import msfm_parser
import aux_func

k = int(sys.argv[1])

text = str()
textl = "'Pravidla';"

outFile = sys.argv[2]

textl += "'NFA States';"
for i in range(1, k+1):
    textl += "'" + str(i) + "';"    
textl += "'N'"
 
text += textl + "\n"

for i in range(3, len(sys.argv)):
    textl = "'" + sys.argv[i] + "';"
    
    ns = nfa_split.nfa_split()
    if aux_func.isPickle(sys.argv[i]) == True:
        ns = ns.load(sys.argv[i])
    else:
        Test0 = msfm_parser.msfm_parser()
        Test0.load_file(sys.argv[i])
        ns.create_by_parser(Test0)
        
    ns.create_det_parts(k)
    textl += str(ns._statistics["NFA States"]) + ";"
    
    for j in range(0, k):
        try:
            data = ns._statistics["NCA Sizes"][j]
            textl += str(data) + ";"
        except:
            textl += "0;"
    
    textl += str(ns._statistics["N Size"]) + ";"
    text += textl + "\n"
f = open(outFile + ".csv", "w");
f.write(text)
f.close()
