###############################################################################
#  dfa_encoder_table_gen.py: Module for PATTERN MATCH
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Vlastimil Kosar <ikosar@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

import nfa_split
import random

maxSize = 2 ^ 16

if __name__ == '__main__':
    random.seed()
    indexes = list([10, 20, 50])
    result = list()
    result2 = list()
    for i in range(0, 4):
        for j in range(0, 3):
            inset = set()
            solution = dict()
            for k in range(0, indexes[j]):
                inset.add(k)
                solution[k] = random.randint(0, maxSize - 1)
            det = nfa_split.nfa_det_part()
            det._inset = inset
            det._solution = solution
            print("[" + str(i) + "][" + str(j) + "] START")
            result.append(det.encoder_size())
            result2.append(det._statistic["Encoder stages"])
            print("[" + str(i) + "][" + str(j) + "] DONE")
        indexes[0] *= 10
        indexes[1] *= 10
        indexes[2] *= 10

    print(result)
    print(result2)