###############################################################################
#  b_dfa.py: Module for PATTERN MATCH - base DFA implementation.
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Vlastimil Kosar <ikosar@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

import sym_char
import sym_char_class
from b_state import b_State
import copy
from b_automaton import b_Automaton
import msfm_parser
from nfa_data import nfa_data
import random
import b_state
import gc
import copy

class b_dfa(b_Automaton):
    """A base class for NFA automata."""
    def __init__(self):
        b_Automaton.__init__(self)
        self._state_representation = list() # List of states in DFA.
                                            # Every state is represented 
                                            # by set of states in NFA
          
    def determinise(self, create_table = False):
        """Determinisation of automaton. If create_table = false than state representation table is not created and less memory is consumed."""
        if self._automaton.Flags.has_key("Deterministic") and self._automaton.Flags["Deterministic"] == True:
            return
        if self._automaton.Flags.has_key("Epsilon Free") == False or self._automaton.Flags["Epsilon Free"] == False:
            self.remove_epsilons()
            
        Stack = list()
        Citac = 0
        newStates = dict()
        newStatesBack = dict()
        tmp = set()
        tmp.add(self._automaton.start)
        newStates[Citac] = tmp
        newStatesBack[frozenset(tmp)] = Citac
        Citac = Citac+1
        Stack.append(0)
        EndStates = set()
        Transitions = set()
        alphabetCounter = 0;
        alphabet = dict()
        alphabetBack = dict()
        states = dict()
        states[0] = b_State(0, self._automaton.states[self._automaton.start].get_regexp_number())
        StateOutSymbols = dict()
        
        for transition in self._automaton.transitions:
            if StateOutSymbols.has_key(transition[0]) == True:
                StateOutSymbols[transition[0]].add((transition[1], transition[2]))
            else:
                StateOutSymbols[transition[0]] = set()
                StateOutSymbols[transition[0]].add((transition[1], transition[2]))

        while len(Stack) != 0:
            ActState = Stack.pop();
            TransitionLine = dict();
            if len(newStates[ActState].intersection(self._automaton.final)) != 0 :
                EndStates.add(ActState)
            Symbols = set();

            SymbolSetList = list()
            translationTable = list()
            
            for States in newStates[ActState]:
                if States in StateOutSymbols.keys():
                    for sym in StateOutSymbols[States]:
                        if isinstance(self._automaton.alphabet[sym[0]], sym_char.b_Sym_char):
                            SymbolSetList.append(set(self._automaton.alphabet[sym[0]].char))
                            translationTable.append(sym[1])
                        elif isinstance(self._automaton.alphabet[sym[0]], sym_char_class.b_Sym_char_class):
                            SymbolSetList.append(self._automaton.alphabet[sym[0]].charClass)
                            translationTable.append(sym[1])
                        else:
                            raise Exception()

            res = self.__allIntersections(SymbolSetList)

            translatedUsedList = list()
            
            for used in res[0]:
                newSet = set()
                for target in used:
                    newSet.add(translationTable[target])
                translatedUsedList.append(newSet)
                
            for i in range(0, len(translatedUsedList)):
                if frozenset(translatedUsedList[i]) not in newStatesBack.keys():
                    newStatesBack[frozenset(translatedUsedList[i])] = Citac;
                    newStates[Citac] = translatedUsedList[i];
                    Stack.append(Citac);
                    
                    #TODO: improve multiple end states in one new state
                    endVal = 0
                    for state in translatedUsedList[i]:
                        if self._automaton.states[state].is_final() == True:
                            endVal = self._automaton.states[state].get_regexp_number()
                            
                    states[Citac] = b_State(Citac, endVal)
                    
                    Citac = Citac + 1
                    
                if frozenset(res[1][i]) not in alphabetBack.keys():
                    alphabetBack[frozenset(res[1][i])] = alphabetCounter;
                    if len(res[1][i]) > 1:
                        strSymSetMod = str()
                        for sym in res[1][i]:
                            strSymSetMod += sym
                        strSymSetMod = "[" + strSymSetMod + "]"
                        Tmp = sym_char_class.b_Sym_char_class(strSymSetMod, res[1][i], alphabetCounter)
                        alphabet[Tmp.get_id()] = Tmp
                    else:
                        for sym in res[1][i]:
                            char = sym
                        Symbol = sym_char.b_Sym_char(char, char, alphabetCounter)
                        alphabet[Symbol.get_id()] = Symbol
                    alphabetCounter += 1
                
                Transitions.add((ActState, alphabetBack[frozenset(res[1][i])], newStatesBack[frozenset(translatedUsedList[i])]))
                    
        self._automaton.start = 0
        self._automaton.alphabet = alphabet
        self._automaton.states = states
        self._automaton.transitions = Transitions
        self._automaton.final = EndStates
        
        if create_table == True:
            for i in range(0, Citac):
                self._state_representation.append(newStates[i]) 
                
        self._automaton.Flags["Deterministic"] = True
        self._automaton.Flags["Epsilon Free"] = True
             
    def minimise(self):
      """Minimalization of DFA automaton."""

      # variables
      a = self._automaton    # shortcut
      t_s = dict()           # transitions sorted
      notComputed = list()   # not computed states
      computed = list()      # available states
      s_ind = dict()         # indistinguishable states
      table = dict()  # table of "transitions", key is state, value is class
      
      if not a.Flags.has_key("Deterministic") \
         or a.Flags["Deterministic"] != True:
          print "Error: Input automaton must be Deterministic."
          return

      # sort transitions
      for s in a.states.keys():
        t_s[s] = list()
      for t in a.transitions:
        t_s[t[0]].append(t)

      # 1) *** Eliminate not available states. ***
      notComputed.append(a.start)
      while notComputed != []:
	computed.append(notComputed[0])
     	for t in t_s[notComputed[0]]:
      		if t[2] not in computed and t[2] not in notComputed:
      			notComputed.append(t[2])
      	del notComputed[0]
      # Change the automaton if any not available state exist.
      if len(a.states.keys()) != len(computed):
        for s in range(0, len(a.states.keys()), 1):
		if s not in computed:
			del a.states[s]
        s_a = sorted(a.states.keys()) # states auxiliary
        # change states
        aux = {}  # auxiliary
        for s in a.states:
          aux[s_a.index(s)] = a.states[s]
          aux[s_a.index(s)]._id = s_a.index(s)
        a.states = aux
        # change final states
        aux = set()
        for s in a.final:
          aux.add(s_a.index(s))
        a.final = aux
        # change transitions
        aux = set()
        usedAlphabet = []
        for t in a.transitions:
          if len(t) == 3:
            aux.add((s_a.index(t[0]), t[1], s_a.index(t[2])))
            usedAlphabet.append(t[1])
        a.transitions = aux
        # change alphabet
        for i in a.alphabet.keys():
		if i not in usedAlphabet:
			del a.alphabet[i]
                
      # 2) *** Compute not indistinguishable states. ***
      # create table of transitions for states
      for s in a.states.keys():
        # -1 is special (helpfully) "state"
        table[s] = [-1] * 256 # needed because of fully specified DFA
      for t in a.transitions:
        if isinstance(a.alphabet[t[1]], sym_char.b_Sym_char):
          table[t[0]][ord(a.alphabet[t[1]].char)] = t[2]
        else :
          for ch in a.alphabet[t[1]].charClass:
            table[t[0]][ord(ch)] = t[2]
      # zero iteration:
      s_ind[0] = list()
      # set first class other then final states
      s_ind[0].append(a.states.keys())
      # set second class final states
      s_ind[0].append(list(a.final))
      for s in a.final:
        s_ind[0][0].remove(s)
      i = 0 # number of iteration, do not use another 'i' in any cycle !!!
      # indistinguishable iterations
      while True:
        cur_table = table # current table for given iteration
        for s in table.keys(): # state
          for ch_i in range(0, len(table[s]), 1): # char index
            # skip looking for -1 state, it is a special state
            if cur_table[s][ch_i] == -1:
              continue
            for clas in range(0, len(s_ind[i]), 1): # class
              if table[s][ch_i] in s_ind[i][clas]:
                cur_table[s][ch_i] = clas
                break
        i += 1
        s_ind[i] = copy.deepcopy(s_ind[i - 1])
        numberClasses = len(s_ind[i]) # number of classes
        for clas in range(0, numberClasses, 1): # class
          # states in class for delete, because they was added to new class
          to_remove = [] 
          # newly created classes from actualy computed class
          newClasses = []
          # index of state in current class
          for i_s in range(1, len(s_ind[i][clas]), 1): 
            # check for states have to be still in this class
            if cur_table[s_ind[i][clas][0]] != cur_table[s_ind[i][clas][i_s]]:
              # state have not to be in this class
              added = False # indication of state added to newly created class
              # chech if state can be join to newly created class
              for newClass in newClasses:
                if cur_table[newClass[0]] == cur_table[s_ind[i][clas][i_s]]:
                  # match, append state to this new class
                  newClass.append(s_ind[i][clas][i_s])
                  added = True
                  break
              # state can not be added to any new class
              if not added:
                # mark new class
                newClasses.append([s_ind[i][clas][i_s]])
              # mark state for delete
              to_remove.append(s_ind[i][clas][i_s])
          # remove new class states from old class
          for s in to_remove:
            s_ind[i][clas].remove(s)
          # append new classes
          for newClass in newClasses:
            s_ind[i].append(newClass)
        # break iterations if two last results are same
        if s_ind[i - 1] == s_ind[i]:
          break
#      print s_ind
      # *** Change to Reduced DFA. ***
      # change STATES
      a.states = dict()
      for clas in range(0, len(s_ind[i]), 1):
        finalIndication = set() # indication of final states
        for s in s_ind[i][clas]:
          if s in a.final:
            finalIndication.add(s)
        a.states[clas] = b_State(mid = clas, rnum = finalIndication)
      # change ALPHABET - nothing to change
      # change START STATE
      for clas in range(0, len(s_ind[i]), 1):
        if a.start in s_ind[i][clas]:
          a.start = clas
          break
      # change TRANSITIONS
      new_t = set() # re-computed transitions
      for t in a.transitions:
        sourceState = -1
        destinationState = -1
        # discover source state
        for indexClass in range(0, len(s_ind[i]), 1):
          if t[0] in s_ind[i][indexClass]:
            sourceState = indexClass
            break
        # discover destination state
        for indexClass in range(0, len(s_ind[i]), 1):
          if t[2] in s_ind[i][indexClass]:
            destinationState = indexClass
            break
        # add new transitions
        new_t.add((sourceState, t[1], destinationState))
      a.transitions = new_t
      # change FINAL STATES
      aux_f = set() # auxiliary final
      for s in a.final:
        for clas in range(0, len(s_ind[i]), 1):
          if s in s_ind[i][clas]:
            aux_f.add(clas)
            break
      a.final = aux_f

      a.Flags["Minimal"] = True

      # 3) *** Removal of surplus state that do not affect the adoption
      # of a string. ***

    def __allIntersections(self, sets):
        """ Compute all posible(in determinisation way, not in mathematic way - when char from set is used in intersection it's removed) intersections of list of char sets """
        
        intersections = list()
        usedSetsList = list()
        
        usedSets = set()
        
        stop = False

        while stop == False:
            intersection = set()
            usedSets = set()
            
            j = 0
            while j < len(sets):
                if (len(sets[j]) > 0):               
                    intersection = sets[j]
                    usedSets.add(j)
                    stop = False
                    break
                else:
                    j += 1
            else:
                stop = True
            
            if stop == False:
                for i in range(j, len(sets)):
                    #if intersection.isdisjoint(sets[i]) == False:
                    if len(intersection.intersection(sets[i])) > 0:
                        intersection = intersection.intersection(sets[i])
                        usedSets.add(i)
            
                intersections.insert(len(intersections), intersection)
                usedSetsList.insert(len(usedSetsList), usedSets)
            
                for k in usedSets:           
                    sets[k] = sets[k].difference(intersection)
                   
                
        return (usedSetsList, intersections)

    # 

    def getTableByGA(self, maxSize):
        generations = 1000
        populationSize = 10
        mutationProbablity = 0.3
        mutationRate = 0.5
        solution = None
        mutationCount = 5
        
        StateOutSymbols = dict()
        
        for transition in self._automaton.transitions:
            if StateOutSymbols.has_key(transition[0]) == True:
                StateOutSymbols[transition[0]].add((transition[1], transition[2]))
            else:
                StateOutSymbols[transition[0]] = set()
                StateOutSymbols[transition[0]].add((transition[1], transition[2]))
        random.seed()
        
        mapper = [0] * len(StateOutSymbols)
        index = 0 
        for state in StateOutSymbols.keys():
            mapper[index] = state
            index += 1
        
        population = list()
        for i in range(0, populationSize):
            subject = [0] * len(StateOutSymbols)
            index = 0
            for j in range(0, len(mapper)):
                subject[index] = random.randint(0, maxSize - 1)
                index += 1
                
            population.append(subject)
        
        for i in range(0, generations):
            fitnesses = self._evaluate(population, maxSize, StateOutSymbols, mapper)
            population = self._create(population, mapper, fitnesses, mutationProbablity, mutationRate, mutationCount, maxSize)
            print("Generation: " + str(i))
        
        if min(fitnesses) <= 0:
            solution = dict()
            for i in range(0, len(mapper)):
                solution[mapper[i]] = population[len(population) - 1][i]
        
            i = len(population) - 1
            memory = [0] * maxSize
            fitness = 0
            for j in range(0, len(mapper)):
                for transition in StateOutSymbols[mapper[j]]:
                    addr = (population[i][j] ^ ord(self._automaton.alphabet[transition[0]].char)) % maxSize
                    print(str(population[i][j]) + " x " + str(ord(self._automaton.alphabet[transition[0]].char)) + "["+self._automaton.alphabet[transition[0]].char+"] = " + str(addr))
                    if memory[addr] != 0:
                        fitness += 1
                    memory[addr] += 1
        
        
        return solution
            
    def _evaluate(self, population, maxSize, StateOutSymbols, mapper):
        fitnesses = [0] * len(population)
        for i in range(0, len(population)):
            memory = [0] * maxSize
            fitness = 0
            maxAddr = 0
            for j in range(0, len(mapper)):
                for transition in StateOutSymbols[mapper[j]]:
                    addr = (population[i][j] ^ ord(self._automaton.alphabet[transition[0]].char)) % maxSize
                    if memory[addr] != 0:
                        fitness += 1
                    if addr > maxAddr:
                        maxAddr = addr
                    memory[addr] += 1
            
            if fitness == 0:
                fitness = fitness - (maxSize - 1) + maxAddr
            
            fitnesses[i] = fitness
        return fitnesses
                    
    def _rank(self, rank, ssum):
        rnd = random.randint(0, ssum - 1)
        
        nsum = 0 
        for i in range(0, len(rank)):
            nsum += rank[i]
            if nsum > rnd:
                return i
        return len(rank) - 1
        
    def _create(self, population, mapper, fitnesses, mutationProbablity, mutationRate, mutationCount, maxSize):
        newPopulation = list()
        length = len(population)
        if mutationProbablity < 1:
            cross = max(int((1.0 - mutationProbablity) * length) - 1, 0)
            muta = length - cross - 1
        else:
            muta = length - 1
            cross = 0
        
        rank = [0] * length
        fit = copy.deepcopy(fitnesses)
        index = length
        ssum = 0
        for i in range(0, length):
            minimum = fit[0]
            ind = 0
            for j in range(1, len(fit)):
                if (fit[j] < minimum):
                    minimum = fit[j]
                    ind = j
            rank[ind] = index
            if i == 0:
                best = ind
            ssum += index
            index -= 1
            fit[ind] = 999999999
                       
        #sum = 0
        #for i in range(0, length):
            #print(i)
            #print(keys)
            #print(keys[i])
            #print(rankDict[keys[i]])
            #rank[rankDict[keys[i]]] = index
            #sum += index
            #index -= 1
                       
        for i in range (0, cross):
            parent1 = self._rank(rank, ssum)
            parent2 = self._rank(rank, ssum)
            point = random.randint(0, len(mapper) - 1)
            child = [0] * len(mapper)
            for j in range(0, len(mapper)):
                if j < point:
                    child[j] = population[parent1][j]
                else:
                    child[j] = population[parent2][j]
            newPopulation.append(child)
        
        for i in range (0, muta):
            child = copy.deepcopy(population[best])
            for j in range(0, mutationCount):
                child[random.randint(0, len(mapper) - 1)] = random.randint(0, maxSize - 1)
            newPopulation.append(child)
        
        newPopulation.append(population[best])
        print("Best: " + str(fitnesses[best]))
        return newPopulation
            
    def getTableByHeuristic(self):
        solution = dict()
        isUsed = set()
        
        StateOutSymbols = dict()
        
        for transition in self._automaton.transitions:
            if StateOutSymbols.has_key(transition[0]) == True:
                StateOutSymbols[transition[0]].add((transition[1], transition[2]))
            else:
                StateOutSymbols[transition[0]] = set()
                StateOutSymbols[transition[0]].add((transition[1], transition[2]))
        
        outCounts = list()
        for state in StateOutSymbols.keys():
            outCounts.append([len(StateOutSymbols[state]), state])
        
        outCounts.sort()
        
        memory = [0] * len(self._automaton.transitions)
        testIsUsed = [0] * 5000000
        minimum = 0
        minOverFlow = len(memory) + 256
        index = 0
        while len(outCounts) > 0:
            print(len(outCounts))
            state = outCounts.pop()
            
            placed = False
            index = minimum
            while placed == False and index < len(memory) + 256:
                #if index not in isUsed:
                if testIsUsed[index] == 0:
                    placed = True
                    #old = copy.copy(memory)
                    for transition in StateOutSymbols[state[1]]:
                        addr = (index ^ ord(self._automaton.alphabet[transition[0]].char))
                        if addr >= len(memory):
                            placed = False
                            if index < minOverFlow:
                                minOverFlow = index
                        else:                    
                            if memory[addr] != 0:
                                placed = False
                                memory[addr] += 1
                            else:
                                memory[addr] += 1
                    if placed == False:
                        for transition in StateOutSymbols[state[1]]:
                            addr = (index ^ ord(self._automaton.alphabet[transition[0]].char))
                            if addr < len(memory):
                                memory[addr] -= 1
                        #memory = old
                        index += 1
                    else:
                        if index == minimum:
                            minimum = index + 1
                        #isUsed.add(index)
                        testIsUsed[index] = 1
                        solution[state[1]] = index
                else:
                    index += 1
      
            if placed == False:
                memory.extend([0] * 256)
                placed = False
                index = minOverFlow
                while placed == False and index < len(memory) + 256:
                    #if index not in isUsed:
                    if testIsUsed[index] == 0:
                        placed = True
                        #old = copy.copy(memory)
                        for transition in StateOutSymbols[state[1]]:
                            addr = (index ^ ord(self._automaton.alphabet[transition[0]].char))
                            if addr >= len(memory):
                                placed = False
                            else:                    
                                if memory[addr] != 0:
                                    placed = False
                                    memory[addr] += 1
                                else:
                                    memory[addr] += 1
                        if placed == False:
                            for transition in StateOutSymbols[state[1]]:
                                addr = (index ^ ord(self._automaton.alphabet[transition[0]].char))
                                if addr < len(memory):
                                    memory[addr] -= 1
                            #memory = old
                            index += 1
                        else:
                            if index == minimum:
                                minimum = index + 1
                            #isUsed.add(index)
                            testIsUsed[index] = 1
                            solution[state[1]] = index
                    else:
                        index += 1
        
        last = 0
        for i in range(0, len(memory)):
            if memory[i] != 0:
                last = i
               
        return [solution, last]
                
    def _removeCharClasses(self):
        charDict = dict()
        maxIndex = -1
        for symbol in self._automaton.alphabet.keys():
            if isinstance(self._automaton.alphabet[symbol], sym_char.b_Sym_char):
                charDict[self._automaton.alphabet[symbol]] = symbol
            #print(str(type(symbol)) + " - " + str(symbol))
            if symbol > maxIndex:
                maxIndex = symbol
        maxIndex += 1
                
        #print(str(charDict.keys()))
                
        removeTransSet = set()
        addTransSet = set()
        
        for transition in self._automaton.transitions:
            if isinstance(self._automaton.alphabet[transition[1]], sym_char_class.b_Sym_char_class):
                for char in self._automaton.alphabet[transition[1]].charClass:
                    sym = sym_char.b_Sym_char(char, char, maxIndex)
                    if charDict.has_key(sym) == False:
                        self._automaton.alphabet[maxIndex] = sym
                        charDict[sym] = maxIndex
                        maxIndex += 1
                        index = maxIndex - 1
                    else:
                        index = charDict[sym]
                    addTransSet.add((transition[0], index, transition[2]))
                    #print("ADD: " + str((transition[0], index, transition[2])))
                    
                removeTransSet.add(transition)
                #print("REMOVE: " + str(transition))
        
        #print(str(self._automaton.alphabet))
        for transitions in removeTransSet:
            self._automaton.transitions.remove(transitions)
            
        for transitions in addTransSet:
            self._automaton.transitions.add(transitions)
            
        removeSymbolSet = set()
        for symbol in self._automaton.alphabet.keys():
            if isinstance(self._automaton.alphabet[symbol], sym_char_class.b_Sym_char_class):
                removeSymbolSet.add(symbol)
        
        
        for symbol in removeSymbolSet:
            del self._automaton.alphabet[symbol]        
        
if __name__ == '__main__':
    gc.disable()
    dfa = b_dfa()
    random.seed()
    #nfa0 = nfa_data()
    #state1 = b_state.b_State(0,0)
    #state2 = b_state.b_State(1,0)
    #state3 = b_state.b_State(2,0)
    #state4 = b_state.b_State(3,1)
    #nfa0.states[0] = state1
    #nfa0.states[1] = state2
    #nfa0.states[2] = state3
    #nfa0.states[3] = state4
    #Symbol = sym_char.b_Sym_char("a", "a", 0)
    #nfa0.alphabet[0] = Symbol
    #nfa0.start = 0
    #nfa0.final.add(3)
    #trans1 = (0,0,1)
    #trans2 = (0,0,2)
    #trans3 = (1,0,3)
    #trans4 = (2,0,3)
    #nfa0.transitions.add(trans1)
    #nfa0.transitions.add(trans2)
    #nfa0.transitions.add(trans3)
    #nfa0.transitions.add(trans4)
    #nfa0.Flags["Epsilon Free"] = True
    Test0 = msfm_parser.msfm_parser()
    Test0.load_file("rules/Moduly/backdoor.rules.pcre")
    #nfa0 = Test0.get_nfa()
    #ns.create_from_nfa_data(nfa0)
    print("--- PARSING ---")
    dfa.create_by_parser(Test0)
    #dfa.create_from_nfa_data(nfa0)
    #dfa._automaton.Show("parsed.dot", "")
    print("--- DETERM ---")
    dfa.determinise(True)
    #dfa._automaton.Show("det.dot", "")
    dfa.remove_unreachable()
    nums = [0]*len(dfa._state_representation)
    for i in range(0, len(dfa._state_representation)):
        nums[i] = len(dfa._state_representation[i])
    maxLen = max(nums)
    hist = [0]*(maxLen + 1)
    print(len(hist))
    for i in range(0, len(nums)):
        hist[nums[i]] += 1
    
    for i in range(0, len(hist)):
        print(str(hist[i]) + ";")
    
    
    
    
    
    #dfa._automaton.Show("drm.dot", "")
    #print("--- REMOVE ---")
    #dfa._removeCharClasses()
    #dfa._automaton.Show("chr.dot", "")
    #print("--- TABLE ---")
    #res = dfa.getTableByGA(16885)
    #if res == None:
    #    print("Nepovedlo se.")
    #else:
    #    print(res)
    #res = dfa.getTableByHeuristic()
    #print(res[0])
    #print("Memory rows: " + str(res[1]))
    #print("States: " + str(len(dfa._automaton.states)) + " Transitions: " + str(len(dfa._automaton.transitions)))
    
    gc.enable()
    
    
###############################################################################
# End of File b_dfa.py                                                        #
###############################################################################
