###############################################################################
#  test_parse_prefixes.py: Test module for parsing prefixes from rulesets
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Martin Skacan <xskaca00@stud.fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

"""
Test module for parsing prefixes from rulesets
"""

import sys
from netbench.classification import prefixset
from netbench.classification.parsers import simplenificparser

# filenames of rulesets in folder classification/rulesets
rulesets = [
 "fw1_05_05.rul",
 "fw1_05_m05.rul",
 "fw1_m05_05.rul",
 "fw1_m05_m05.rul",
 "fw2_05_05.rul",
 "fw2_05_m05_100.rul",
 "fw2_05_m05_250.rul",
 "fw2_05_m05_500.rul",
 "fw2_05_m05.rul",
 "fw2_m05_05.rul",
 "fw2_m05_m05.rul",
 "fw3_05_05_500.rul",
 "fw5_05_05_500.rul"
]

# we will use NificParser to get prefixes
parser = simplenificparser.SimpleNificParser()
filename = "../classification/rulesets/" + rulesets[0]
parser.load_file(filename)
rules = parser.get_rules()

# parse source and destination IP addresses from rules
dictionary = rules.get_prefixes(["srcipv4", "dstipv4"])
srcprefixes = dictionary['srcipv4']
dstprefixes = dictionary['dstipv4']
print "srcipv4: ", len(srcprefixes.get_prefixes())
print "dstipv4: ", len(dstprefixes.get_prefixes())

# join scr and dst prefixes into one PrefixSet
prefixes = prefixset.PrefixSet()
for prefix in srcprefixes.get_prefixes():
    prefixes.add_prefix(prefix)
for prefix in dstprefixes.get_prefixes():
    prefixes.add_prefix(prefix)
print "sum of all unique prefixes: ", len(prefixes.get_prefixes())

# save joined prefixes into file
file = open("parsed_prefixes.out", 'w')
for prefix in prefixes.get_prefixes():
    file.write(str(prefix))
    file.write("\n")
file.close()