###############################################################################
#  test.py: Test module for IP parsers and LPM methods
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Martin Skacan <xskaca00@stud.fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

"""
Test module for IP parsers and LPM methods
"""

import sys
from parsers import ipv4parser
from parsers import ipv6parser
from algorithms import trie
from algorithms import treebitmap
from algorithms import multimatch
from algorithms import sst
from algorithms import cpe
from algorithms import lulea
from algorithms import bsi
from algorithms import bsp

parser = ipv4parser.Ipv4Parser()
prefixset = parser.get_prefixes()

parser6 = ipv6parser.Ipv6Parser()
prefixset6 = parser6.get_prefixes()


print "=== IPV4PARSER ===\n"
filename = "prefixes/ipv4/test_prefixes.txt"
if (parser.load_file(filename)):
    print "From file", filename, "were loaded these prefixes:"
    prefixset.display("prefix")
else:
    print "Cannot load file",filename

print "\ncount of lines in file test.py"
print parser.get_lines_of_file("test.py")

print "count of lines in last loaded file"
print parser.get_count_of_lines()

print "count of successful parsed prefixes from last loaded file"
print parser.get_parsed_prefixes()

print "count of invalid prefixes in last loaded file"
print parser.get_invalid_prefixes()


print "\n=== IPv6 PARSER ===\n"
filename = "prefixes/ipv6/test_prefixes.txt"
if parser6.load_file(filename):
	print "From file", filename, "were loaded these prefixes:"
	prefixset6.display("prefix6")
else:
	print "Cannot load file", filename

filename = "test.py"
print "\nCount of lines in file", filename, "."
print parser6.get_lines_of_file(filename)

print "Count of lines in last loaded file."
print parser6.get_count_of_lines()

print "Count of successful parsed prefixes from last loaded file."
print parser6.get_parsed_prefixes()

print "count of nonvalid prefixes in last loaded file."
print parser6.get_nonvalid_prefixes() 

# IP PRO VSECHNY ALGORITMY
list_ip = [192,168,1,4]
ip = 0
for i in list_ip:
	ip += int(i)
	ip = ip << 8
ip = ip >> 8

print "\n"
print "=== LPM TRIE ==="
my_trie = trie.Trie()
my_trie.load_prefixset(prefixset)

print "trie lookup"
list = my_trie.lookup(ip)
for p in list:
    p.display()
print ""

print "prefixset match"
list = prefixset.match(ip)
for p in list:
    p.display()
print ""

print "trie check"
print my_trie.check(ip)

print "report memory"
report = my_trie.report_memory()
print "prefixes", report['prefixes']
print "nodes", report['nodes']
print "pointers", report['pointers']

print "statistics of prefixset"
print "mean length of prefixes", prefixset.get_mean_length()
print "histogram"
print prefixset.get_histogram()

print "\nTrie display\n"
my_trie.display()

print "\n=== Tree bitmap ==="

tb = treebitmap.TreeBitmap(3)
tb.load_prefixset(prefixset)

print "\nTree bitmap display\n"
tb.display(tb.tree.root)


#ip = [246,0,0,0]
print "tree bitmap lookup"
list = tb.lookup(ip)
for p in list:
    p.display()
print ""

print "prefixset match"
list = prefixset.match(ip)
for p in list:
    p.display()
print ""

print "tree bitmap check"
print tb.check(ip)

print "report memory"
report = tb.report_memory()
print "prefixes", report['prefixes']
print "nodes", report['nodes']
print "child pointers", report['child_pointers']
print "prefix pointers", report['prefix_pointers']



print "\n=== Multimatch ==="
multi = multimatch.MultiMatch(4, 1)
multi.load_prefixset(prefixset)

#ip = [244,16,0,0]

print "multimatch lookup"
list = multi.lookup(ip)
for p in list:
    p.display()
print ""

print "multimatch check"
print multi.check(ip)
report = multi.report_memory()
print "Prefix length | Table size | Prefixes in it"
print "-------------------------------------------"
for i in range(0,len(report['prefixes'])):
    str1 = str(multi.expand_mask[i])
    str2 = str(report['tables'][i])
    print str1.center(13, ' '),"|",str2.center(10, ' '),"|  ", report['prefixes'][i] 


print "\n=== Dynamic Multimatch ==="
multi = multimatch.MultiMatch(4, 2)
multi.load_prefixset(prefixset)

#ip = [244,16,0,0]

print "multimatch lookup"
list = multi.lookup(ip)
for p in list:
    p.display()
print ""

print "multimatch check"
print multi.check(ip)
report = multi.report_memory()
print "Prefix length | Table size | Prefixes in it"
print "-------------------------------------------"
for i in range(0,len(report['prefixes'])):
    str1 = str(multi.expand_mask[i])
    str2 = str(report['tables'][i])
    print str1.center(13, ' '),"|",str2.center(10, ' '),"|  ", report['prefixes'][i]  


print "\n=== Shape-shifting trie ==="
sst = sst.SST(3)
sst.load_prefixset(prefixset)
sst.display(sst.tree.root)
#ip = [161,34,94,202]
list = sst.lookup(ip)
for p in list:
    p.display()
print ""

print "prefixset match"
list = prefixset.match(ip)
for p in list:
    p.display()
print ""

print "tree bitmap check"
print sst.check(ip)

print "report memory"
report = sst.report_memory()
print "prefixes", report['prefixes']
print "nodes", report['nodes']
print "child pointers", report['child_pointers']
print "prefix pointers", report['prefix_pointers']


print "\n=== CPE trie ===\n"
# CPE(n), n = pocet bitu zpracovavanych v jednom taktu
my_cpe = cpe.CPE(4)
# nacti prefixi a vytvor strom
my_cpe.load_prefixset(prefixset)

#ip = [242, 2, 3, 4]

print "Zkouska funkce lookup jestli najde prefix pro danou ip adresu. Nasleduje najity prefix:"
print my_cpe.lookup(ip)

print "\nPrefixset match"
print prefixset.match(ip)
print "Report memory."
print my_cpe.report_memory()
print "Mean length of prefixes:", prefixset.get_mean_length()
print "Histogram:"
print prefixset.get_histogram()
print "\n=== display CPE tree ===\n"
my_cpe.display()

print "\n=== LULEA trie ===\n"
# LULEA(n), n = pocet bitu zpracovavanych v jednom taktu
my_lulea = lulea.LULEA(4)
# nacti prefixi a vytvor strom
my_lulea.load_prefixset(prefixset)

#ip = [242, 15, 12, 16]

print "Zkouska funkce lookup:", my_lulea.lookup(ip)
print "\nPrefixset match:", prefixset.match(ip)
print "Report memory."
print my_lulea.report_memory()
print "\n=== display LULEA tree ===\n"
my_lulea.display()


print "\n=== BSI ===\n"
my_bsi = bsi.BSI()
my_bsi.load_prefixset(prefixset)
#ip = [245, 1, 21, 8]
print "Zkouska vlastni lookup:", my_bsi.lookup(ip)
print "Prefixset match:", prefixset.match(ip)
print "Report memory:", my_bsi.report_memory()
print "\n=== display BSI table ===\n"
my_bsi.display()

print "\n=== BSP ===\n"
my_bsp = bsp.BSP()
my_bsp.load_prefixset(prefixset)
#ip = [245, 2, 3, 4]
print "Zkouska vlastni funkce lookup:", my_bsp.lookup(ip)
print "Prefixset match:", prefixset.match(ip)
print "Report memory:", my_bsp.report_memory()
#print "\n=== display BSP ===\n"
#my_bsp.display()
print "\nReport memory od CPE, Lulea, BSI, BSP:"
print "CPE:",my_cpe.report_memory()
print "Lul:",my_lulea.report_memory()
print "BSI:",my_bsi.report_memory()
print "BSP:",my_bsp.report_memory()
