###############################################################################
#  test_sst.py: Test module for SST LPM method
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Martin Skacan <xskaca00@stud.fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

"""
Test module for SST LPM method
"""

import sys
import netbench.lpm.parsers.ipv4parser as ipv4parser
import netbench.lpm.algorithms.sst as sst
from netbench.classification import maskedint

synth =[ ["srcfw1_05_m05", "srcfw1_m05_m05", "srcfw2_05_05", "srcfw2_05_m05_100", "srcfw2_m05_05", "srcfw3_05_05_500", "srcfw4_05_05_500", "srcfw5_05_05_500"],
        ["dstfw1_05_m05", "dstfw1_m05_m05", "dstfw2_05_05", "dstfw2_05_m05_100", "dstfw2_m05_05", "dstfw3_05_05_500", "dstfw4_05_05_500", "dstfw5_05_05_500"],
        ["bothfw1_05_m05", "bothfw1_m05_m05", "bothfw2_05_05", "bothfw2_05_m05_100", "bothfw2_m05_05", "bothfw3_05_05_500", "bothfw4_05_05_500", "bothfw5_05_05_500"] ]

outfile = "test_sst.out"
path = "../prefixes/ipv4/fw/"

# compute and print memory demands and stats of currently loaded prefixset
def compute():
    file.write("\n*************** Filename: " + filename + " ***************\n")
    file.write("Count of successful parsed prefixes: " + str(parser.get_parsed_prefixes()))
    file.write("\nCount of invalid prefixes: " + str(parser.get_invalid_prefixes()))
    file.write("\nHistogram:\n\t")
    # get histogram of currently loaded prefixset
    histogram = prefixset.get_histogram()
    for i in histogram:
        file.write(str(i) + " ")

    file.write("\nMean length of prefixes: " + str(prefixset.get_mean_length()))
    
    file.write("\n --- SHAPE-SHIFTING TREE ---")
    # parameters K which will be applied for SST
    parameters = [4,8,16,32]
    for k in parameters:
        file.write("\n" + 40*"-")
        file.write("\nParameter K: " + str(k))
        my_sst = sst.SST(k)
        my_sst.load_prefixset(prefixset)
        report = my_sst.report_memory()
        file.write("\nPrefixes: " + str(report['prefixes']))
        file.write("\nNodes: " + str(report['nodes']))
        file.write("\nChild pointers: " + str(report['child_pointers']))
        file.write("\nPrefix pointers: " + str(report['prefix_pointers']))
        file.write("\nMemory accesses in worst case: " + str(report['depth']))
        file.write("\nMemory demands [Bytes]\n")
        # size of bitmaps
        ibm = k
        ebm = k+1
        sbm = 2*k
        file.write("32-bit pointer: " + str(report['nodes']*(sbm + ibm + ebm + 64.0)/8))
        # compute minimal possible pointer size
        prefix_ptr = maskedint.log2(report['prefixes'])
        node_ptr = maskedint.log2(report['nodes'])
        file.write("\nSmallest possible: " + str(report['nodes']*(sbm + ibm + ebm + prefix_ptr + node_ptr)/8.0))
    file.write("\n" + 80*"*" + "\n")

# try to open a file
try:
    file = open(outfile, 'w')
except IOError:
    print "Cannot open file for writing results"
    exit()

       
print "COMPUTING - synthetic prefixes"
file.write("\n\n\n==================================================\n")
file.write("----------===== SYNTHETIC PREFIXES =====----------\n")
file.write("==================================================\n")

# perform tests with each of given prefixsets
for i in range(len(synth[0])):
    for j in range(len(synth)):
        filename = path + "synth/" + synth[j][i]
        parser = ipv4parser.Ipv4Parser()
        prefixset = parser.get_prefixes()
        if (parser.load_file(filename)):
            print "test file:", filename
            compute()
        else:
            print "Cannot load file",filename
print "DONE.."
print "Results are in file", outfile
file.close()
