###############################################################################
#  test_fw_lookup.py: Test module for ipv4parser and LPM methods: trie,
#                     Tree Bitmap, SST and multi-match
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Martin Skacan <xskaca00@stud.fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

"""
Test module for IPv4 parser and LPM methods
"""

import sys
from netbench.lpm.parsers import ipv4parser
from netbench.lpm.algorithms import trie
from netbench.lpm.algorithms import treebitmap
from netbench.lpm.algorithms import multimatch
from netbench.lpm.algorithms import sst

# intitialize ipv4parser
parser = ipv4parser.Ipv4Parser()
prefixset = parser.get_prefixes()

# ip addres that will be looked up
ip = 0
list_ip = [240,0,0,0]
for i in list_ip:
    ip += int(i)
    ip = ip << 8
ip = ip >> 8


print "=== IPV4PARSER ===\n"
filename = "../prefixes/ipv4/test_prefixes"
if (parser.load_file(filename)):
    print "From file", filename, "were loaded these prefixes:"
    prefixset.display("prefix")
else:
    print "Cannot load file",filename

print "\ncount of lines in last loaded file"
print parser.get_count_of_lines()

print "count of successful parsed prefixes from last loaded file"
print parser.get_parsed_prefixes()

print "count of invalid prefixes in last loaded file"
print parser.get_invalid_prefixes()

print "\nmean length of prefixes:", prefixset.get_mean_length()
print "histogram:"
print prefixset.get_histogram()

print "\nprefixset match"
list = prefixset.match(ip)
for p in list:
    p.display()
print ""

print "\n"
print "=== LPM TRIE ==="
my_trie = trie.Trie()
my_trie.load_prefixset(prefixset)

print "trie lookup"
list = my_trie.lookup(ip)
for p in list:
    p.display()
print ""

print "trie check - ",
print my_trie.check(ip)

print "\nReport memory:"
report = my_trie.report_memory()
print "prefixes", report['prefixes']
print "nodes", report['nodes']
print "pointers", report['pointers']

print "\nTrie display\n"
my_trie.display()

print "\n=== Tree Bitmap ==="

tb = treebitmap.TreeBitmap(3)
tb.load_prefixset(prefixset)

print "tree bitmap lookup"
list = tb.lookup(ip)
for p in list:
    p.display()
print ""

print "tree bitmap check - ",
print tb.check(ip)

print "\nReport memory:"
report = tb.report_memory()
print "prefixes", report['prefixes']
print "nodes", report['nodes']
print "child pointers", report['child_pointers']
print "prefix pointers", report['prefix_pointers']

print "\nTree bitmap display\n"
tb.display(tb.tree.root) 

print "\n=== Shape-shifting trie ==="
sst = sst.SST(4)
sst.load_prefixset(prefixset)

print "sst lookup"
list = sst.lookup(ip)
for p in list:
    p.display()
print ""

print "tree bitmap check - ",
print sst.check(ip)

print "\nReport memory:"
report = sst.report_memory()
print "prefixes", report['prefixes']
print "nodes", report['nodes']
print "child pointers", report['child_pointers']
print "prefix pointers", report['prefix_pointers']

print "\nSST display\n"
sst.display(sst.tree.root)

print "\n=== Multimatch ==="
multi = multimatch.MultiMatch(4, 1)
multi.load_prefixset(prefixset)

print "multimatch lookup"
list = multi.lookup(ip)
for p in list:
    p.display()
print ""

print "multimatch check - ",
print multi.check(ip)

print "\nReport memory:"
report = multi.report_memory()
print "Prefix length | Table size | Prefixes in it"
print "-------------------------------------------"
for i in range(0,len(report['prefixes'])):
    str1 = str(multi.expand_mask[i])
    str2 = str(report['tables'][i])
    print str1.center(13, ' '),"|",str2.center(10, ' '),"|  ", report['prefixes'][i] 


print "\n=== Dynamic Multimatch ==="
multi = multimatch.MultiMatch(4, 2)
multi.load_prefixset(prefixset)

print "multimatch lookup"
list = multi.lookup(ip)
for p in list:
    p.display()
print ""

print "multimatch check - ",
print multi.check(ip)

print "\nReport memory:"
report = multi.report_memory()
print "Prefix length | Table size | Prefixes in it"
print "-------------------------------------------"
for i in range(0,len(report['prefixes'])):
    str1 = str(multi.expand_mask[i])
    str2 = str(report['tables'][i])
    print str1.center(13, ' '),"|",str2.center(10, ' '),"|  ", report['prefixes'][i]
