###############################################################################
#  blpm.py: Module with abstract class for all LPM algorithms
#  Copyright (C) 2009 Brno University of Technology, ANT @ FIT
#  Author(s): Martin Skacan <xskaca00@stud.fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

"""
Module providing abstract class for all LPM algorithms.
"""

import sys
from netbench.classification.prefixset import *

class BLPM(object):
    """
    Base abstract class for all LPM algorithms.
    """

    def __init__(self):
        """Constructor"""

    def report_memory(self):
        """
        Print detailed info about algorithm memory requirements. Abstract method.
        """
        # Will be implemented in derived class.
        
    def load_prefixset(self, prefixset):
        """
        Load prefixes and generate all necessary data structures. Abstract method.
        """
        # Will be implemented in derived class.

    def lookup(self, ip):
        """
        Lookup prefixes that match ip. Abstract method.
        Return the list of matched prefixes. 
        If ip matches no prefix, the list will be empty.
         
        ip: value of the ip address according to maskedint.py
        """
        # Will be implemented in derived class.

    def check(self, ip):
        """
        Return True if LPM algorithm result is correct.
        It checks list of all prefixes that match
        
        ip: value of the ip address according to maskedint.py
        """

        if self.lookup(ip) == \
           self.prefixset.match(ip):
            return True
        else:
            return False
    
    def check_longest(self, ip):
        """
        Return True if LPM algorithm result is correct.
        It checks only the longenst prefix that match
        
        ip: value of the ip address according to maskedint.py
        """

        if self.lookup(ip) == \
           self.prefixset.match_longest(ip):
            return True
        else:
            return False

