#! /usr/bin/env python
# file : traffic.py

import sys
import pcapfile
import packetheader
 
###############################################################################
# Class for parsing files with packets (wrapper over PcapFile)
# This is here for backward compatibility only, use PcapFile for new modules!
###############################################################################
class Traffic(object):
    """Class for parsing files with packets"""

    def __init__(self):
        self.pcapfile = pcapfile.PcapFile()

    def set_file(self, filename):
        """Opens file with packets."""
        try:
            self.pcapfile.open(filename)
        except IOError:
            # Catch exception and return False on error, to achieve the same 
            # behavior as original Traffic class.
            return False
        return True
        

    def set_filter(self, filterstring):
        raise NotImplemented("Sorry, set_filter method not implemented.")
        

    def next_packet(self, packet):
        """Returns next packet in the file."""
        if self.pcapfile.opened:
            tmppacket = self.pcapfile.next_packet()
            if tmppacket:
                packet.raw_data = tmppacket.raw_data
                packet.pckthdr = packetheader.PacketHeader()
                packet.pckthdr.push_header(tmppacket.pckthdr['info'])
                return True
            else:
                return False
        



