#!/usr/bin/env python

import sys
 
class ProtoHeader(object):
    """
    Class providing access to fields of protocol header
    """
    def __init__(self, headertype, header_fields=None):
        if header_fields:
            self.header_fields = header_fields
        else:
            self.header_fields = {}
        self.header_type   = headertype

    def get_field(self, name):
        """Returns field of a given name"""
        if self.header_fields.has_key(name):
            return self.header_fields[name]
        else:
            return None

    def get_header_type(self):
        """Returns name of protocol header"""
        return self.header_type
        
    def set_field(self, name, value):
        """Set field of a given name to a given value"""
        self.header_fields[name]=value
    
    def __getitem__(self, name):
        """
        Allows getting header fields by indexing. Returns field of a given name.
        """
        try:
            return self.header_fields[name]
        except KeyError:
            return None
    
    def __setitem__(self, name, value):
        """
        Allows setting header fields by indexing.
        """
        self.header_fields[name]=value
    
    
    def __repr__(self):
        """Returns string representing the instance"""
        return "<ProtoHeader %s>"%self.header_type 



