#!/bin/python

import sys
import protoheader
 
class PacketHeader(object):
    """
    Class for providing access to protocol headers
    """
    def __init__(self, header_list=None):
        if header_list==None:
            self.header_list = []
        else:
            self.header_list = header_list 

    def push_header(self, protoheader):
        """Add protocol header into a list of headers"""
        return self.header_list.append(protoheader)
        
    def get_header(self, type, occurence=0):
        """
        Returns ProtoHeader of given type.

        type 
            Name of protocol, for example: tcp.
        occurence 
            Order of protocol in case two protocols are the same, e.g., IP in IP
        """
        pos = 0
        type_list = self.get_headers_type()
        if type_list.count(type) > occurence:
            for i in range(0, occurence+1):
                pos = type_list.index(type, pos)
            return self.header_list[pos]
        else:
            return None
    
    def __getitem__(self, i):
        """
        Allows getting protocol headers by indexing.
        If i is a number, returns i-th header.
        If i is a string, returns header with that name.
        """
        if isinstance(i,basestring):
            for h in self.header_list:
                if h.get_header_type() == i:
                    return h
            raise KeyError("Packet doesn't contain header named " + i)
        else:
            try:
                return self.header_list[i]
            except TypeError, e:    
                raise TypeError("PacketHeader index must be integer or string")
        
    def get_headers_type(self):
        """
        Returns list of protocols in packet header.
        """
 
        return [i.get_header_type() for i in self.header_list]

    def iterfields(self):
        """
        Returns iterator through values of all fields in all headers.
        """
        for hdr in self.header_list:
            for field in hdr.header_fields.itervalues():
                yield field
    
    

def ipv4str2int(ipstr):
    """
    Convert IP in string format x.x.x.x into an integer,

    ipstr: IPv4 addres in traditional text notation with dots.
    """
    s = map(int, ipstr.split("."))
    i  = s[0] << 24
    i |= s[1] << 16
    i |= s[2] << 8
    i |= s[3]
    return i


def ipv4str2bytelist(ipstr):
    """
    Convert IP in string format x.x.x.x into list of numbers,
    one number for each byte, [0] is MSB.

    ipstr: IPv4 addres in traditional text notation with dots.
    """
    return map(int, ipstr.split("."))

def int2bytelist(integer, bytes=4):
    """
    Convert integer number into list of one-byte numbers, [0] is MSB

    integer: integer to convert.
    """
    return [((integer >> i*8) & 0xFF) for i in range(bytes-1,-1,-1)]

