#!/usr/bin/env python2.6

###############################################################################
#  test.py: Test module for basic classes used in packet 
#  classification experiments
#  Copyright (C) 2009 Brno University of Technology, ANT @ FIT
#  Author(s): Viktor Pus <ipus@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id: test_prefix.py 314 2010-04-17 14:13:25Z ipus $

"""
Test module for Prefix class used in packet classification experiments
"""

from prefix import *

print '==== Prefix test ===='

prefix1 = Prefix(32, 192*2**24+168*2**16+100*2**8+1, display_format="range", length=32)
prefix2 = Prefix(32, 192*2**24+168*2**16+100*2**8+1, display_format="ipv4_prefix", length=24)

print "display()"
prefix1.display()
prefix2.display()
print ""
print "print"
print prefix1
prefix1.set_display_format("ipv4_prefix")
print prefix1
print prefix2
prefix2.set_display_format("range")
print prefix2

print "get_range()"
print prefix1.get_range()
print prefix2.get_range()

print "match()"
ip=192*2**24 + 168*2**16 + 100*2**8 + 1
print ip
print prefix1.match(ip)
print prefix2.match(ip)
ip=192*2**24 + 168*2**16 + 100*2**8 + 2
print ip
print prefix1.match(ip)
print prefix2.match(ip)

prefix3 = Prefix(32, 192*2**24+168*2**16+100*2**8+1, display_format="range", length=32)
print prefix1, '==', prefix2, prefix1 == prefix2
print prefix1, '==', prefix3, prefix1 == prefix3

print prefix1, "covers", prefix2, prefix1.covers(prefix2)
print prefix2, "covers", prefix1, prefix2.covers(prefix1)

print "set_mask()"
prefix3.set_mask(2**32-1024)
print prefix3
prefix3.set_display_format("ipv4_prefix")
print prefix3

print "ipv6 test"
prefix4 = Prefix(128, 33*2**120, display_format="ipv6_prefix", length=127)
print prefix4
