#!/usr/bin/env python2.6

###############################################################################
#  test_maskedint.py: Test module for basic classes used in packet 
#  classification experiments
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Viktor Pus <ipus@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id: test_maskedint.py 314 2010-04-17 14:13:25Z ipus $

"""
Test module for MaskedInt class used in packet classification experiments
"""

from maskedint import *

print '==== MaskedInt test ===='

masked1 = MaskedInt(128, mask=254, domain_size=8, display_format="range")

print "display()"
masked1.display()
print ""
print "print"
print masked1

print "match()"
print 128, masked1.match(128)
print 129, masked1.match(129)
print 130, masked1.match(130)

masked2 = MaskedInt(129, mask=255)
masked3 = MaskedInt(129, mask=254)
masked4 = MaskedInt(128, mask=252)
masked5 = MaskedInt(128, mask=254) # Same as masked1

print 'Comparison by \"==\"'
print masked1, "==", masked2, "?",
print masked1 == masked2

print masked1, "==", masked3, "?",
print masked1 == masked3

print masked1, "==", masked4, "?",
print masked1 == masked4

print masked1, "==", masked5, "?",
print masked1 == masked5

print 'Comparison by \"is\":',
print masked1 is masked5 # Python built-in: Object identity

print "covers()"
print masked1, "covers", masked2, "?",
print masked1.covers(masked2)

print masked1, "covers", masked3, "?",
print masked1.covers(masked3)

print masked3, "covers", masked1, "?",
print masked3.covers(masked1)

print masked4, "covers", masked1, "?",
print masked4.covers(masked1)

print masked1, "covers", masked4, "?",
print masked1.covers(masked4)
