#!/usr/bin/env python

###############################################################################
#  stats.py: Statistics about classification rulesets
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Viktor Pus <ipus@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id: stats.py 410 2010-08-21 13:29:22Z ipus $

"""
Module computing basic and advanced statistics about rulesets
"""

from netbench.classification.prefix import *
from netbench.classification.prefixset import *
from netbench.classification.rule import *
from netbench.classification.ruleset import *

from netbench.classification.parsers.simplenificparser import *

filelist = [\
"fw1_05_05.rul", \
"fw2_05_05.rul",\
"fw2_05_m05.rul",\
"fw4_05_05_500.rul",\
"fw1_05_m05.rul",\
"fw2_05_m05_100.rul",\
"fw2_m05_05.rul",\
"fw5_05_05_500.rul",\
"fw1_m05_05.rul",\
"fw2_05_m05_250.rul",\
"fw2_m05_m05.rul",\
"fw1_m05_m05.rul",\
"fw2_05_m05_500.rul",\
"fw3_05_05_500.rul",\
"simple.rul"\
]

filelist = [\
"rules3.rul", \
]

filter_covered = True
print_histograms = False
print_nesting = False

for file in filelist:
    print "Ruleset", file
    parser = SimpleNificParser()
    parser.load_file(file)

    parsedrules = parser.get_rules()
    print "  Number of rules : ", parsedrules.count_rules()

    if (filter_covered):
        filteredrules = RuleSet()
        for r in parsedrules.get_rules():
            filteredrules.add_rule(r, check=True)
        print "  Number of rules after input filtering: ", filteredrules.count_rules()
        parsedrules = filteredrules

    prefixes = parsedrules.get_prefixes()
    for field in prefixes.keys():
        pset = prefixes[field]
        print "  Field", field
        print "    Number of unique values:", len(pset.get_prefixes())

        if (print_histograms):
            print "    Histogram of lengths: ", pset.get_histogram()

        if (print_nesting):
            maxnest = 0
            for p in pset.get_prefixes():
                nest = pset.get_nesting(p)
                if (nest > maxnest):
                    maxnest = nest
                    maxnested = p
            print "    Max prefix nesting level:", maxnest

            if (maxnest > 0):
                covering = []
                for p in pset.get_prefixes():
                    if (p.covers(maxnested) and p is not maxnested):
                        covering.append(p)
                print "      For example", maxnested, "is covered by", covering
