###############################################################################
#  prefix_coloured.py: Module for operations with coloured prefixes for PCCA
#                      algorithm
#  Copyright (C) 2009 Brno University of Technology, ANT @ FIT
#  Author(s): Michal Kajan <ikajan@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id: prefix_coloured.py 485 2010-09-21 13:54:44Z xbarto11 $

"""
Module providing extensions to the original Prefix class.
"""


import prefix


class PrefixColoured(prefix.Prefix):
    """
    Derived class extending original Prefix class. Allows to add some specific information
    to the prefix object. This class is used in Prefix Coloured Crossproduct Algorithm.
    """

    def __init__(self, domain_size=32):
        """
        Constructor, optionally with domain_size parameter.
        Default is 32 (as for IPv4 address).
        """
#        # One number for each byte of prefix
#        # _data[0] is the MSB
#        self._data = []
#
#        # Number of valid bits (default full length)
#        self._length = domain_size
#
#        # Domain size : Maximum prefix length
#        # Default value is for IPv4. 
#        # Set to 16 for port number, 128 for IPv6, ...
#        # If (_domain_size % 8 != 0) then higher bits of _data[0] are unused
#        self._domain_size = domain_size
 
        super(PrefixColoured, self).__init__(domain_size)

        # empty dictionary, dictionary will store bitmaps for every dimension
        # bitmap stores information which colours given prefix neighbours
        self._bitmap_set = {}


    def set_bitmaps(self, bitmaps):
        """
        Set bitmap information for this prefix, new bitmaps will be
        assigned to the attribute _bitmap_set
        """
        self._bitmap_set = bitmaps

    def get_bitmaps(self):
        """
        Return set of bitmaps for this prefix.
        """
        return self._bitmap_set

    def set_colour(self, colour):
        """
        Assign color for this prefix
        """
        self._colour = colour

    def get_colour(self):
        """
        Return color number of this prefix
        """
        return self._colour


    def set_condition(self, condition):
        """
        """
        self._condition = condition

    def get_condition(self):
        """
        """
        return self._condition


    def __str__(self, format = ""):
        return super(PrefixColoured, self).__str__(format) + "\n   color " + str(self._colour) + ", bitmaps: " + str(self._bitmap_set) + "\n"
