#!/usr/bin/env python2.6

###############################################################################
#  test.py: Test module for all classification algorithms
#  Copyright (C) 2010 Brno University of Technology, ANT @ FIT
#  Author(s): Martin Spinler <xspinl00@stud.fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id: $


import sys

from netbench.common.pcapfile import *
from netbench.classification.common import *
from netbench.classification.parsers.simplenificparser import *

# TODO: Automatically scan current folder for class derived from BClassifcitaion
algorithms = {
    'dcfl'  : 'DCFL',
    'msca'  : 'MSCA',
    'pcca'  : 'PCCA', 
    'phca'  : 'PHCA'}
    #'hicuts': 'HiCuts',

run_classification = False

# Parameters check
print sys.argv
if (len(sys.argv) <= 2) or (sys.argv[1] not in algorithms.keys()):
    alg_list = "|".join(algorithms.keys())
    sys.stderr.write("Usage: ./test.py {" + alg_list + "} ruleset\n")
    exit(1)

filename = sys.argv[2] 
alg_id = sys.argv[1]
alg_name = algorithms[alg_id]

# Import a classification algorithm
module = __import__("netbench.classification.algorithms." + alg_id, fromlist = ["*"])

print '===== ' + alg_name + ' Test ====='
# Create instance of class
test = eval("module." + alg_name + "()")

# Load ruleset from file
print "Loading input ruleset: ", filename
parser = SimpleNificParser()
if (not parser.load_file(filename)):
    print "Error occured when parsing input file\n"
    exit()

# Load ruleset into algorithm
ruleset = parser.get_rules()
test.load_ruleset(ruleset)

if run_classification:
    print "===== Classification test ====="
    # Obtain some packets
    pcap = PcapFile("../../common/test.pcap")
    i = 0
    for p in pcap:
        hdr = p.get_packet_header()
        i += 1
        print "Classifying packet %d:" % i,
        try:
            rule = test.classify(hdr)
        except BadPacketError:
            print "Not IPv4 Packet"
            continue

        if (rule == []):
            rule = [None]

        rule2 = [ ruleset.classify_first(hdr) ]

        if (rule[0] == rule2[0]):
            print "OK, rule priority:", "None" if rule2[0] is None else rule2[0].get_priority()
        else:
            print "FAILED, correct rule priority:", rule2[0].get_priority()
            rule2[0].display()
            print "classify() returned", rule[0]
            for h in hdr.iterfields():
                print repr(h)
            exit(-1)
         
print 
test.report_memory()

