--##############################################################################
--  cp_stage.vhd: Color Processing Stage VHDL implementation
--  Copyright (C) 2011 Brno University of Technology, ANT @ FIT
--  Author(s): Viktor Pus <ipus@fit.vutbr.cz>
--##############################################################################
--
--  LICENSE TERMS
--
--  Redistribution and use in source and binary forms, with or without
--  modification, are permitted provided that the following conditions
--  are met:
--  1. Redistributions of source code must retain the above copyright
--     notice, this list of conditions and the following disclaimer.
--  2. Redistributions in binary form must reproduce the above copyright
--     notice, this list of conditions and the following disclaimer in
--     the documentation and/or other materials provided with the
--     distribution.
--  3. All advertising materials mentioning features or use of this software
--     or firmware must display the following acknowledgement:
--
--       This product includes software developed by the University of
--       Technology, Faculty of Information Technology, Brno and its
--       contributors.
--
--  4. Neither the name of the Company nor the names of its contributors
--     may be used to endorse or promote products derived from this
--     software without specific prior written permission.
--
--  This software or firmware is provided ``as is'', and any express or implied
--  warranties, including, but not limited to, the implied warranties of
--  merchantability and fitness for a particular purpose are disclaimed.
--  In no event shall the company or contributors be liable for any
--  direct, indirect, incidental, special, exemplary, or consequential
--  damages (including, but not limited to, procurement of substitute
--  goods or services; loss of use, data, or profits; or business
--  interruption) however caused and on any theory of liability, whether
--  in contract, strict liability, or tort (including negligence or
--  otherwise) arising in any way out of the use of this software, even
--  if advised of the possibility of such damage.
--
--  $Id: math_pack.vhd 586 2011-01-04 11:00:10Z ipus $

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

package math_pack is
   function log2 (n : integer) return integer;
end math_pack;

package body math_pack is
   function log2 (n : integer) return integer is
      variable a, m : integer;
   begin
      if (n = 1) then
         return 0;
      end if;
      a := 0;
      m := 1;
      while m < n loop
         a := a + 1;
         m := m * 2;
      end loop;
      return a;
   end log2;
end math_pack;

