###############################################################################
#  bclassification.py: Module with abstract class for classification algorithms
#  Copyright (C) 2009 Brno University of Technology, ANT @ FIT
#  Author(s): Viktor Pus <ipus@fit.vutbr.cz>
###############################################################################
#
#  LICENSE TERMS
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#  3. All advertising materials mentioning features or use of this software
#     or firmware must display the following acknowledgement:
#
#       This product includes software developed by the University of
#       Technology, Faculty of Information Technology, Brno and its
#       contributors.
#
#  4. Neither the name of the Company nor the names of its contributors
#     may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  This software or firmware is provided ``as is'', and any express or implied
#  warranties, including, but not limited to, the implied warranties of
#  merchantability and fitness for a particular purpose are disclaimed.
#  In no event shall the company or contributors be liable for any
#  direct, indirect, incidental, special, exemplary, or consequential
#  damages (including, but not limited to, procurement of substitute
#  goods or services; loss of use, data, or profits; or business
#  interruption) however caused and on any theory of liability, whether
#  in contract, strict liability, or tort (including negligence or
#  otherwise) arising in any way out of the use of this software, even
#  if advised of the possibility of such damage.
#
#  $Id$

"""
Module providing abstract class for packet classification algorithms.
"""

import sys
import netbench.classification.ruleset

class BClassification(object):
    """
    Base abstract class for all classification algorithms.
    """

    def __init__(self):
        """Constructor"""

    def load_ruleset(self, ruleset):
        """
        Load rules and generate all necessary data structures. Abstract method.
        """
        # Will be implemented in derived class.

    def classify(self, packetheader):
        """
        Classify packet by the algorithm. Abstract method.
        Return the list of matched rules. 
        If the algorithm doesn't support multimatch, the list will have only one item.
        If packet matches no rule, the list will be empty.

        packetheader: Instance of the PacketHeader class.
        """
        # Will be implemented in derived class.

    def check(self, packetheader):
        """
        Return True if algorithm result is correct.

        packetheader: Instance of the PacketHeader class.
        """

        if self.classify(packetheader) == \
           self.ruleset.classify(packetheader):
            return True
        else:
            return False

    def report_memory(self):
        """
        Print detailed info about algorithm memory requirements. Abstract method.
        """
        # Will be implemented in derived class.

