/*
 * TSPoptView.java
 */
package tspopt;

import javax.swing.ListSelectionModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Scanner;
import javax.naming.ldap.ManageReferralControl;
import javax.swing.DefaultListModel;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ListModel;

/**
 * The application's main frame.
 */
public class TSPoptView extends FrameView {

    public TSPoptView(SingleFrameApplication app) {
        super(app);

        initComponents();

        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {

            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String) (evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer) (evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        jTabbedPaneLayouts = new javax.swing.JTabbedPane();
        jToolBar1 = new javax.swing.JToolBar();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem10 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        jMenu3 = new javax.swing.JMenu();
        jMenuItem4 = new javax.swing.JMenuItem();
        jMenuItem5 = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        jMenuItem9 = new javax.swing.JMenuItem();
        jMenuItem7 = new javax.swing.JMenuItem();
        jMenuItem8 = new javax.swing.JMenuItem();
        jMenuItem6 = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        jDialogMergeChains = new javax.swing.JDialog();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldMergeChainName = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jListChainsToMerge = new javax.swing.JList();
        jButtonMergeOK = new javax.swing.JButton();
        jButtonMergeCancel = new javax.swing.JButton();

        mainPanel.setName("mainPanel"); // NOI18N

        jTabbedPaneLayouts.setName("jTabbedPaneLayouts"); // NOI18N

        jToolBar1.setRollover(true);
        jToolBar1.setName("jToolBar1"); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 822, Short.MAX_VALUE)
            .addComponent(jTabbedPaneLayouts, javax.swing.GroupLayout.DEFAULT_SIZE, 822, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTabbedPaneLayouts, javax.swing.GroupLayout.DEFAULT_SIZE, 426, Short.MAX_VALUE))
        );

        menuBar.setName("menuBar"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(tspopt.TSPoptApp.class).getContext().getResourceMap(TSPoptView.class);
        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(tspopt.TSPoptApp.class).getContext().getActionMap(TSPoptView.class, this);
        jMenuItem1.setAction(actionMap.get("newScanLayout")); // NOI18N
        jMenuItem1.setText(resourceMap.getString("jMenuItem1.text")); // NOI18N
        jMenuItem1.setName("jMenuItem1"); // NOI18N
        fileMenu.add(jMenuItem1);

        jMenuItem10.setAction(actionMap.get("autoLoadTest2")); // NOI18N
        jMenuItem10.setText(resourceMap.getString("jMenuItem10.text")); // NOI18N
        jMenuItem10.setName("jMenuItem10"); // NOI18N
        fileMenu.add(jMenuItem10);

        jMenuItem2.setText(resourceMap.getString("jMenuItem2.text")); // NOI18N
        jMenuItem2.setName("jMenuItem2"); // NOI18N
        fileMenu.add(jMenuItem2);

        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        jMenu3.setText(resourceMap.getString("jMenu3.text")); // NOI18N
        jMenu3.setName("jMenu3"); // NOI18N

        jMenuItem4.setAction(actionMap.get("addFFPositionsFromFile")); // NOI18N
        jMenuItem4.setText(resourceMap.getString("jMenuItem4.text")); // NOI18N
        jMenuItem4.setName("jMenuItem4"); // NOI18N
        jMenu3.add(jMenuItem4);

        jMenuItem5.setAction(actionMap.get("addChainFromFile")); // NOI18N
        jMenuItem5.setText(resourceMap.getString("jMenuItem5.text")); // NOI18N
        jMenuItem5.setName("jMenuItem5"); // NOI18N
        jMenu3.add(jMenuItem5);

        jSeparator1.setName("jSeparator1"); // NOI18N
        jMenu3.add(jSeparator1);

        jMenuItem9.setAction(actionMap.get("mergeChainsClicked")); // NOI18N
        jMenuItem9.setText(resourceMap.getString("jMenuItem9.text")); // NOI18N
        jMenuItem9.setName("jMenuItem9"); // NOI18N
        jMenu3.add(jMenuItem9);

        jMenuItem7.setText(resourceMap.getString("jMenuItem7.text")); // NOI18N
        jMenuItem7.setName("jMenuItem7"); // NOI18N
        jMenu3.add(jMenuItem7);

        jMenuItem8.setAction(actionMap.get("deleteChain")); // NOI18N
        jMenuItem8.setText(resourceMap.getString("jMenuItem8.text")); // NOI18N
        jMenuItem8.setName("jMenuItem8"); // NOI18N
        jMenu3.add(jMenuItem8);

        jMenuItem6.setAction(actionMap.get("renameChain")); // NOI18N
        jMenuItem6.setText(resourceMap.getString("jMenuItem6.text")); // NOI18N
        jMenuItem6.setName("jMenuItem6"); // NOI18N
        jMenu3.add(jMenuItem6);

        menuBar.add(jMenu3);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 822, Short.MAX_VALUE)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(statusMessageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 638, Short.MAX_VALUE)
                .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(statusMessageLabel)
                    .addComponent(statusAnimationLabel)
                    .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(3, 3, 3))
        );

        jDialogMergeChains.setModal(true);
        jDialogMergeChains.setName("jDialogMergeChains"); // NOI18N

        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N

        jTextFieldMergeChainName.setName("jTextFieldMergeChainName"); // NOI18N

        jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
        jLabel6.setName("jLabel6"); // NOI18N

        jScrollPane3.setName("jScrollPane3"); // NOI18N

        jListChainsToMerge.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jListChainsToMerge.setName("jListChainsToMerge"); // NOI18N
        jScrollPane3.setViewportView(jListChainsToMerge);

        jButtonMergeOK.setAction(actionMap.get("mergeChains")); // NOI18N
        jButtonMergeOK.setText(resourceMap.getString("jButtonMergeOK.text")); // NOI18N
        jButtonMergeOK.setName("jButtonMergeOK"); // NOI18N

        jButtonMergeCancel.setAction(actionMap.get("mergeCancel")); // NOI18N
        jButtonMergeCancel.setText(resourceMap.getString("jButtonMergeCancel.text")); // NOI18N
        jButtonMergeCancel.setName("jButtonMergeCancel"); // NOI18N

        javax.swing.GroupLayout jDialogMergeChainsLayout = new javax.swing.GroupLayout(jDialogMergeChains.getContentPane());
        jDialogMergeChains.getContentPane().setLayout(jDialogMergeChainsLayout);
        jDialogMergeChainsLayout.setHorizontalGroup(
            jDialogMergeChainsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jDialogMergeChainsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jDialogMergeChainsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jDialogMergeChainsLayout.createSequentialGroup()
                        .addComponent(jLabel5)
                        .addGap(18, 18, 18)
                        .addComponent(jTextFieldMergeChainName, javax.swing.GroupLayout.DEFAULT_SIZE, 267, Short.MAX_VALUE))
                    .addGroup(jDialogMergeChainsLayout.createSequentialGroup()
                        .addComponent(jLabel6)
                        .addGap(18, 18, 18)
                        .addGroup(jDialogMergeChainsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jDialogMergeChainsLayout.createSequentialGroup()
                                .addComponent(jButtonMergeOK, javax.swing.GroupLayout.DEFAULT_SIZE, 124, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonMergeCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 283, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jDialogMergeChainsLayout.setVerticalGroup(
            jDialogMergeChainsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jDialogMergeChainsLayout.createSequentialGroup()
                .addGap(11, 11, 11)
                .addGroup(jDialogMergeChainsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(jTextFieldMergeChainName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jDialogMergeChainsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel6)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 85, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jDialogMergeChainsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonMergeOK)
                    .addComponent(jButtonMergeCancel))
                .addContainerGap(11, Short.MAX_VALUE))
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
    }// </editor-fold>//GEN-END:initComponents

    @Action
    public void newScanLayout() {
        LayoutPanel a = new LayoutPanel(jTabbedPaneLayouts);
        a.setName("xxx");
        jTabbedPaneLayouts.add(a);

    }


    @Action
    public void addFFPositionsFromFile() {
        JFileChooser fc = new JFileChooser(new File("P:/DISERTACE"));

        fc.setDialogTitle("Choose a flip-flop position file...");

        if (fc.showOpenDialog(this.getComponent()) == JFileChooser.APPROVE_OPTION) {
            addFFPositionsFromFile(fc.getSelectedFile());
        }


    }
    public void addFFPositionsFromFile(File file) {
        try {
            Scanner scanner = new Scanner(file);
            try {
                LayoutPanel layoutPanel = (LayoutPanel) jTabbedPaneLayouts.getSelectedComponent();
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();

                    Scanner scannerLine = new Scanner(line);
                    String path = scannerLine.next();
                    String coor = scannerLine.next();
                    scannerLine.close();

                    Scanner scannerPath = new Scanner(path);
                    scannerPath.useDelimiter("/");
                    String name;
                    do {
                        name = scannerPath.next();
                    } while (scannerPath.hasNext());
                    scannerPath.close();

                    coor = coor.replace('(', ' ');
                    coor = coor.replace(')', ' ');
                    coor = coor.replace(',', ' ');
                    Scanner scannerCoor = new Scanner(coor);
                    scannerCoor.useLocale(Locale.ENGLISH);
                    //scannerCoor.useDelimiter("\\(|\\)|,");
                    double x1, y1, x2, y2, x3, y3, x4, y4;
                    x1 = scannerCoor.nextDouble();
                    y1 = scannerCoor.nextDouble();
                    x2 = scannerCoor.nextDouble();
                    y2 = scannerCoor.nextDouble();
                    x3 = scannerCoor.nextDouble();
                    y3 = scannerCoor.nextDouble();
                    x4 = scannerCoor.nextDouble();
                    y4 = scannerCoor.nextDouble();

                    double x, y, w, h;
                    x = Math.min(x1, Math.min(x2, Math.min(x3, x4)));
                    y = Math.min(y1, Math.min(y2, Math.min(y3, y4)));
                    w = Math.max(x1, Math.max(x2, Math.max(x3, x4))) - x;
                    h = Math.max(y1, Math.max(y2, Math.max(y3, y4))) - y;

                    scannerCoor.close();

                    try {
                        FlipFlop ff;
                        ff = new FlipFlop(path, name, x, y, w, h);
                        layoutPanel.addFlipFlop(ff);
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                layoutPanel.repaint();
            } finally {
                scanner.close();
            }

        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    @Action
    public void addChainFromFile() {
        JFileChooser fc = new JFileChooser(new File("P:/DISERTACE"));

        fc.setDialogTitle("Choose a scan chain order file...");

        if (fc.showOpenDialog(this.getComponent()) == JFileChooser.APPROVE_OPTION) {
            addChainFromFile(fc.getSelectedFile());
        }
    }

    public void addChainFromFile(File file) {
        try {
            Scanner scanner = new Scanner(file);


            if (scanner.hasNextLine()) {
                scanner.nextLine();		//skip 2 lines
            }
            if (scanner.hasNextLine()) {
                scanner.nextLine();
            }
            LayoutPanel layoutPanel = (LayoutPanel) jTabbedPaneLayouts.getSelectedComponent();
            Chain ch = null;


            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();

                Scanner scannerLine = new Scanner(line);

                String chain, type, inv, path, path_full;
                int cell, gate;
                try {
                    chain = scannerLine.next();
                    if (chain.equals("//")) {
                        chain = scannerLine.next(); //skip "//"
                    }
                    cell = scannerLine.nextInt();
                    type = scannerLine.next();
                    inv = scannerLine.next();
                    gate = scannerLine.nextInt();
                    path_full = scannerLine.next();

                    //path = path_full.substring(0, path_full.lastIndexOf('/'));
                } catch (Exception e) {
                    if (scanner.hasNextLine()) {
                        scanner.nextLine();		//skip next line, it's a header
                    }
                    continue;
                }
                FlipFlop ff = layoutPanel.getFFbyPath(path_full);
                if (ff == null) {
                    path_full = path_full.substring(0, path_full.lastIndexOf('/'));
                    ff = layoutPanel.getFFbyPath(path_full);
                    if (ff == null) {
                        System.out.println("FlipFlop ".concat(path_full).concat(" not found in layout"));
                        continue;
                    }
                }
                ch = layoutPanel.getChainByName(/*fc.getName(fc.getSelectedFile()).concat(": ").concat(*/chain/*)*/);
                if (ch == null) {
                    ch = new Chain(/*fc.getName(fc.getSelectedFile()).concat(": ").concat(*/chain/*)*/, layoutPanel.getVisPanel());
                    layoutPanel.addChain(ch);
                }
                ch.addFlipFlop(ff);
            }
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (Exception ex) {
        }
    }

    @Action
    public void deleteChain() {
        LayoutPanel layoutPanel = (LayoutPanel) jTabbedPaneLayouts.getSelectedComponent();
        Object[] objects = new String[layoutPanel.getChains().size()];
        Iterator<Chain> iter = layoutPanel.getChains().iterator();
        int i = 0;
        while (iter.hasNext()) {
            objects[i++] = iter.next().getChainName();
        }
        String chainName = (String) JOptionPane.showInputDialog(mainPanel, "Select chain to remove", "Remove chain", JOptionPane.QUESTION_MESSAGE, null, objects, objects[0]);
        iter = layoutPanel.getChains().iterator();
        while (iter.hasNext()) {
            Chain ch = iter.next();
            if (ch.getChainName().equals(chainName)) {
                layoutPanel.removeChain(ch);
                break;
            }
        }
    }

    @Action
    public void mergeChainsClicked() {
        jTextFieldMergeChainName.setText("");
        LayoutPanel layoutPanel = (LayoutPanel) jTabbedPaneLayouts.getSelectedComponent();
        DefaultListModel listModel = new DefaultListModel();
        Iterator<Chain> iter = layoutPanel.getChains().iterator();
        while (iter.hasNext()) {
            listModel.addElement(iter.next().getChainName());
        }
        jListChainsToMerge.setModel(listModel);

        jDialogMergeChains.setSize(jDialogMergeChains.getPreferredSize());
        jDialogMergeChains.setVisible(true);

    }

    @Action
    public void mergeChains() {
        LayoutPanel layoutPanel = (LayoutPanel) jTabbedPaneLayouts.getSelectedComponent();
        Chain ch = new Chain(jTextFieldMergeChainName.getText(), layoutPanel.getVisPanel());
        ListModel model = jListChainsToMerge.getModel();
        int[] selectedIndices = jListChainsToMerge.getSelectedIndices();
        for (int i = 0; i < selectedIndices.length; i++) {
            String chainName = model.getElementAt(selectedIndices[i]).toString();
            Chain ch1 = layoutPanel.getChainByName(chainName);
            Iterator<FlipFlop> iter = ch1.getFFIterator();
            while (iter.hasNext()) {
                ch.addFlipFlop(iter.next());
            }
        }
        layoutPanel.addChain(ch);
        jDialogMergeChains.setVisible(false);
    }

    @Action
    public void mergeCancel() {
        jDialogMergeChains.setVisible(false);
    }

    @Action
    public void renameChain() {
        LayoutPanel layoutPanel = (LayoutPanel) jTabbedPaneLayouts.getSelectedComponent();
        Object[] objects = new String[layoutPanel.getChains().size()];
        Iterator<Chain> iter = layoutPanel.getChains().iterator();
        int i = 0;
        while (iter.hasNext()) {
            objects[i++] = iter.next().getChainName();
        }
        String chainName = (String) JOptionPane.showInputDialog(mainPanel, "Select chain to rename", "Rename chain", JOptionPane.QUESTION_MESSAGE, null, objects, objects[0]);
        iter = layoutPanel.getChains().iterator();
        while (iter.hasNext()) {
            Chain ch = iter.next();
            if (ch.getChainName().equals(chainName)) {
                String newName = (String) JOptionPane.showInputDialog(mainPanel, "Enter new name", "Rename chain", JOptionPane.QUESTION_MESSAGE);
                ch.setName(newName);
                layoutPanel.repaint();
                break;
            }
        }
    }

    @Action
    public void autoLoadTest2() {
        newScanLayout();
        addFFPositionsFromFile(new File("/home/bartos/P/DISERTACE/test_02_position.txt"));
        addChainFromFile(new File("/home/bartos/DISERTACE/test_02_cell_order.lst"));
    }

    private Chain getActualChain(){
        LayoutPanel layoutPanel = (LayoutPanel) jTabbedPaneLayouts.getSelectedComponent();
        return layoutPanel.getActualChain();
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonMergeCancel;
    private javax.swing.JButton jButtonMergeOK;
    private javax.swing.JDialog jDialogMergeChains;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JList jListChainsToMerge;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem10;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem4;
    private javax.swing.JMenuItem jMenuItem5;
    private javax.swing.JMenuItem jMenuItem6;
    private javax.swing.JMenuItem jMenuItem7;
    private javax.swing.JMenuItem jMenuItem8;
    private javax.swing.JMenuItem jMenuItem9;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JTabbedPane jTabbedPaneLayouts;
    private javax.swing.JTextField jTextFieldMergeChainName;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    // End of variables declaration//GEN-END:variables
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
}
