/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package tspopt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Point2D.Double;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.math.stat.clustering.Clusterable;


/**
 *
 * @author Pavel Bartoš
 */
public class FlipFlop implements Clusterable<FlipFlop> {
    private int gate, cell;
    private String inv, type, path, name;
    private double x, y, w, h;
    private Point2D.Double center;
    private boolean selected = false;
    private boolean manhattan = true;
    private boolean ad = false;
    private boolean da = false;

    public FlipFlop(String path, String name, double x, double y, double w, double h){
        this(0, 0, "", "", path, name, x, y, w, h);
    }

    public FlipFlop(int gate, int cell, String inv, String type, String path, String name, double x, double y, double w, double h) {
        this.gate = gate;
        this.cell = cell;
        this.inv = inv;
        this.type = type;
        this.path = path;
        this.name = name;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;

        this.center = new Point2D.Double(x + w/2, y + h/2);
    }

    public int getCell() {
        return cell;
    }

    public int getGate() {
        return gate;
    }

    public String getInv() {
        return inv;
    }

    public String getName() {
        return name;
    }

    public String getPath() {
        return path;
    }

    public String getType() {
        return type;
    }

    public void paint(Graphics g, double scale, Color color) {
        if (selected)
            g.setColor(Color.RED);
        else
            g.setColor(color);
        g.fillRect((int)(x*scale),(int)(y*scale),(int)(w*scale), (int)(h*scale));
        /*g.setColor(new Color(0, 0, 0));
        g.drawRect((int)(x*scale),(int)(y*scale),(int)(w*scale), (int)(h*scale));
        int fontSize = 14;
        double stringWidth = 0;
        do
        {
        	fontSize--;
        	g.setFont(new Font(Font.DIALOG, Font.PLAIN, fontSize));
        	stringWidth = g.getFontMetrics().stringWidth(name);
        } while(stringWidth > w*scale);*/
        //g.drawString(name,(int)((x+1)*scale/*+w/2*scale - stringWidth/2*scale*/),(int)(y*scale + 4*scale));
    }

    public double getH() {
        return h;
    }

    public double getW() {
        return w;
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    public Double getCenter() {
        return center;
    }

    public boolean isInFlipflop(Point p, double scale){
        double px = p.x/scale;
        double py = p.y/scale;
        return (px >= x && px <= x+w && py >= y && py <= y+h);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setManhattan(boolean manhattan) {
        this.manhattan = manhattan;
    }

    


    public double distanceFrom(FlipFlop ff) {
       return distanceFrom(ff.getCenter().getX(), ff.getCenter().getY());
    }
    public double distanceFrom(double x, double y){
        if (manhattan) {
            return Math.abs(x - this.getCenter().getX()) + Math.abs(y - this.getCenter().getY());
        } else {
            return Math.sqrt((x - this.getCenter().getX()) * (x - this.getCenter().getX()) + (y - this.getCenter().getY()) * (y - this.getCenter().getY()));
        }
    }

    public FlipFlop centroidOf(Collection<FlipFlop> clctn) {
        double sumX = 0, sumY = 0;
        for (Iterator<FlipFlop> iter = clctn.iterator(); iter.hasNext();) {
            FlipFlop ff = iter.next();
            sumX += ff.getCenter().getX();
            sumY += ff.getCenter().getY();
        }
        sumX /= clctn.size();
        sumY /= clctn.size();

        FlipFlop centr = null;
        double minDist = java.lang.Double.MAX_VALUE;
        for (Iterator<FlipFlop> iter = clctn.iterator(); iter.hasNext();) {
            FlipFlop ff = iter.next();
            if (centr == null || ff.distanceFrom(sumX, sumY) < minDist){
                centr = ff;
                minDist = ff.distanceFrom(sumX, sumY);
            }
        }
        return centr;
    }

    public void setAd(boolean ad) {
        this.ad = ad;
    }

    public void setDa(boolean da) {
        this.da = da;
    }

    public boolean isAd() {
        return ad;
    }

    public boolean isDa() {
        return da;
    }

    
    

}
