#!/usr/bin/perl
#Example of Perl script - learning the hierarchy and detect the parts in another set of images

#Path to the application
$program = "hop32.exe";

#Text file containing list of images for learning the hierarchy
#Structure of those lists is one image path/relative path per line
#The application accepts images in 24bit BMP or 8bit PGM file format
#Using huge datasets or part count for learning could be memory demanding
$learn = "testn.txt";
#Text file containing list of images for extracting the learned parts
$match = "testn.txt";

#Working directory
$wf = "testx";

#Number of edge direction in level one parts
$gfangles = 6;
#Edge threshold
$ethreshold = 0.2;
#Corner threshold
$cthreshold = 0.0001;

#Number of layers
$nlayers = 5;
#Maximum number of subparts in composition
$nsubparts = 5;
#Resolution reduction factor
$factor = 2.0;
#Maximum pixel overlap between parts when constructing spatial maps
$ioverlap = 0.3;
#Maximum pixel overlap between parts when grouping parts
$goverlap = 0.5;
#Maximum number of parts per individual layer for sorting
$layerparts = "{100,300,600,200}";

#Visualize detected parts
$printmaps = 1;
#Export list of detected parts
#List of detected parts exported in single text file per image
#in format - x_position y_position part_index
$exportmaps = 1;
#Show progress during computation
$progress = 1;

$cmd0 = "perl tree.pl $wf $nlayers";
$cmd1 = "$program learn input=$learn nlayers=$nlayers nsubparts=$nsubparts factor=$factor wf=$wf goverlap=$goverlap ioverlap=$ioverlap layerparts=$layerparts progress=$progress gfangles=$gfangles ethreshold=$ethreshold cthreshold=$cthreshold";

#Using different threshold for detecting parts
$ethreshold = 0.1;
$cthreshold = 0.00001;

$cmd2 = "$program match input=$match factor=$factor wf=$wf progress=$progress gfangles=$gfangles ethreshold=$ethreshold cthreshold=$cthreshold exportmaps=$exportmaps printmaps=$printmaps";

system $cmd0;
system $cmd1;
system $cmd2;