#!/bin/sh
# $1 should be "image" or "video"
# $2 should be uri of image or video

# - test first argument -
if [ "$1" != "image" ]
then
   if [ "$1" != "video" ]
   then
      echo "First argument should be \"image\" or \"video\""
      exit
   fi
fi

# - test second argument -
if [ "$2" != "" ]
then
   echo UPLOADING: $1 path: \"$2\"

   filename=`basename $2`
   ext=${2##*.}
   mime="$1/"$ext
   parm=""

   echo "curl --header \"Content-Type:$mime\" -T \"$2\" \"http://localhost:9081/$1$3\""
   curl --header "Content-Type:$mime" -T "$2" "http://localhost:9081/$1$3"
else
   echo "Missing second argument, $1 uri"
   exit
fi

