#!/usr/bin/python

from __base import *
from __pgsql import *

x_scale = 500
y_scale = 500

texture_name_color_dict = {
   "unknown" : "#ffffff",
   "trees" : "#0a7d00",
   "road" : "#666666",
   "structure" : "#c20000",
   "grass" : "#32a027",
   "lamp" : "#818181",
   "sign" : "#818181",
   "column" : "#aaaaaa",
   "pavement" : "#818181",
   "wall" : "#d40000",
   "water" : "#357ff9",
   "roof" : "#aaaaaa",
   "sky" : "#91a6c8",
   "fire" : "#da1906",
}

# ------------------------------------------------------------------------------
def get_texture_and_object_types():

   # - get texture types from DB -
   texture_id_name_dict = {}

   sql_query = "SELECT id,name FROM texture_types"
   f_pgsql_execute(sql_query)
   assert db_cursor.rowcount > 1

   for res in db_cursor.fetchall():
      texture_id_name_dict[int(res[0])] = res[1]

   # - get object types from DB -
   object_id_name_dict = {}

   sql_query = "SELECT id,name FROM object_types"
   f_pgsql_execute(sql_query)
   assert db_cursor.rowcount > 1

   for res in db_cursor.fetchall():
      object_id_name_dict[int(res[0])] = res[1]

   return (texture_id_name_dict,object_id_name_dict)

# ------------------------------------------------------------------------------
def get_image_objects(a_object_id_name_dict,a_img_id):
   global x_scale
   global y_scale

   for obj_id in a_object_id_name_dict.keys():
      sql_query = "SELECT id,AsText(position),scale_w,scale_h,type_id FROM objects WHERE type_id=%d AND img_id=%d" % (obj_id,a_img_id)
      f_pgsql_execute(sql_query)

      if db_cursor.rowcount > 0:

         print """<g fill="#9f00a6" stroke="none">"""

         for res in db_cursor.fetchall():
            pos_spl = res[1].split(" ")

            width = float(res[2])*x_scale
            height = float(res[3])*y_scale
            x_pos = float(pos_spl[0].split("(")[-1])*x_scale 
            y_pos = float(pos_spl[-1].split(")")[0])*y_scale

            print """<rect width="%f" height="%f" x="%f" y="%f" id="rect%d" />""" % (width,height,x_pos,y_pos,int(res[0]))
            print "<text style=\"font-size:9;fill:#000000;fill-opacity:1;stroke:none;font-family:Sans\" x=\"%f\" y=\"%f\">%s</text>\n" % (x_pos + width/10.0,y_pos + height/2.0,a_object_id_name_dict[obj_id])

         print "</g>"

# ------------------------------------------------------------------------------
def get_image_segments(a_texture_id_name_dict,a_img_id):
   for tex_id in a_texture_id_name_dict.keys():

      sql_query = "SELECT id,AsText(shape) FROM segments WHERE texture_id=%d AND img_id=%d" % (tex_id,a_img_id)
      f_pgsql_execute(sql_query)

      if db_cursor.rowcount > 0:

         tex_name = a_texture_id_name_dict[tex_id]
         if (texture_name_color_dict.has_key(tex_name)):
            tex_color = texture_name_color_dict[tex_name]
         else:
            tex_color = "#000000"

         seg_id_strings = ""

         print """<g fill="%s" fill-rule="evenodd" stroke="none">""" % tex_color

         for res in db_cursor.fetchall():
            seg_areas = res[1].split("((")[-1].split("))")[0].split("),(")

            first_area = True
            avg_point = [0.0,0.0]
            point_count = 0

            data_str = ""

            for area in seg_areas:
               points = area.split(",")
               point_lst = points[0].split(" ")
               data_str += "M %f,%f " % (float(point_lst[0])*x_scale,float(point_lst[1])*y_scale)

               if first_area:
                  avg_point[0] += float(point_lst[0])*x_scale
                  avg_point[1] += float(point_lst[1])*y_scale
                  point_count += 1

               for point in points:
                  point_lst = point.split(" ")
                  data_str += "%f,%f " % (float(point_lst[0])*x_scale,float(point_lst[1])*y_scale)

                  if first_area:
                     avg_point[0] += float(point_lst[0])*x_scale
                     avg_point[1] += float(point_lst[1])*y_scale
                     point_count += 1

               data_str += "Z "
               first_area = False

            print """<path id="path%d" d="%s" />""" % (int(res[0]),data_str)

            avg_point[0] /= point_count
            avg_point[1] /= point_count
            seg_id_strings += "<text style=\"font-size:10;fill:#ff00ff;fill-opacity:1;stroke:none;font-family:Sans\" x=\"%f\" y=\"%f\">%s</text>\n" % (avg_point[0],avg_point[1],res[0])

         print "</g>"
         print seg_id_strings

# ------------------------------------------------------------------------------
def print_svg_head():
   global x_scale
   global y_scale

   print """<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.1" width="%d" height="%d" id="svg2">""" % (x_scale,y_scale)

# ------------------------------------------------------------------------------
def print_svg_tail():
   print """</svg>
"""

# - PROGRAM START - ============================================================

# - expected arguments <db_image_id> <source image> <target image> -
if len(sys.argv) != 2:
   err_msg("Expected exactly one argument: <image uri>")
   sys.exit(1)

ARG_img_uri = sys.argv[1]

sql_query = "SELECT id FROM images WHERE uri='%s'" % ARG_img_uri
f_pgsql_execute(sql_query)

if db_cursor.rowcount == 1:
   img_id = int(db_cursor.fetchone()[0])

   (texture_id_name_dict,object_id_name_dict) = get_texture_and_object_types()

   print_svg_head()
   get_image_segments(texture_id_name_dict,img_id)
   get_image_objects(object_id_name_dict,img_id)
   print_svg_tail()
else:
   wrn_msg("Cannot find image with uri=\"%s\" in database" % ARG_img_uri)

f_pgsql_release_database(0)
sys.exit(0)

