
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <unistd.h>
#include <limits.h>
#include <math.h>

#include <vector>
#include <set>

#include <opencv/cv.h>
#include <opencv/highgui.h>

using namespace std;

// - bit count of basic types -
const unsigned INT_BIT = (sizeof(int)*CHAR_BIT);
const unsigned UINT_BIT = (sizeof(unsigned)*CHAR_BIT);

// - constants and definitions -
const float c_pi_number = 3.14159265358979323844;
const float c_2pi_number = 6.28318530717958647688;

// - conversion constants -
#define c_icsv ((sizeof(int) - sizeof(char)) << 3)

// - get image pixel size -
inline int get_IplImage_pixel_size(IplImage *a_img)
{/*{{{*/
   return (a_img->depth & 0xff) >> 3;
}/*}}}*/

// - get image ROI -
inline void get_IplImage_roi(IplImage *a_img,int &a_x_offset,int &a_y_offset,int &a_width,int &a_height)
{/*{{{*/
   if (a_img->roi != NULL) {
      a_x_offset = a_img->roi->xOffset;
      a_y_offset = a_img->roi->yOffset;
      a_width = a_img->roi->width;
      a_height = a_img->roi->height;

      return;
   }

   a_x_offset = 0;
   a_y_offset = 0;
   a_width = a_img->width;
   a_height = a_img->height;
}/*}}}*/

#pragma pack(1)
struct two_floats_s
{
   float real;
   float imag;
};
#pragma pack()

bool compute_1D_FFT(bool a_forward,unsigned a_size_power,unsigned char *a_data,unsigned a_data_step);

// - image operations -
bool convert_32S_to_8U(IplImage *a_src,IplImage *a_trg);
bool convert_8U_to_2x32F(IplImage *a_src,IplImage *a_trg);
bool convert_2x32F_to_8U(IplImage *a_src,IplImage *a_trg);
bool convert_2x32F_to_32F(IplImage *a_src,IplImage *a_trg);

bool invert(IplImage *a_src,IplImage *a_trg);
bool normalize(int a_border,IplImage *a_src,IplImage *a_trg);

bool compute_integral_image(IplImage *a_src,IplImage *a_trg);
bool generate_gaabor_function(double a_lambda,double a_phi,double a_psi,double a_sigma,double a_gamma,IplImage *a_img);

bool compute_fft(IplImage *a_img,bool a_forward,unsigned a_w_power,unsigned a_h_power);
bool swap_quarters(IplImage *a_img);

bool deinterlace(IplImage *a_src,IplImage *a_trg);

bool seg_lbp_compute_offset_and_multiplier_array(IplImage *a_src,unsigned a_pattern_length,unsigned a_radius,vector<unsigned> &a_om_array);
bool seg_lbp_compute_LBP_by_offset_and_mutiplier_array(IplImage *a_src,IplImage *a_trg,unsigned a_pattern_length,unsigned a_radius,vector<unsigned> &a_om_array);
bool seg_lbp_compute_LBP(IplImage *a_src,IplImage *a_trg,unsigned a_pattern_length,unsigned a_radius);

bool seg_compute_cooccurence_matrix(IplImage *a_src,IplImage *a_trg,unsigned a_x_step,unsigned a_y_step);

bool seg_watershed(IplImage *a_src,IplImage *a_trg,unsigned a_seed_gap,unsigned *a_region_cnt);

// - feature vector functions -
const unsigned c_lbp_blank_value = 255;
bool compute_feature_vectors_from_lbp_image(IplImage *a_img,unsigned a_lbp_block_side,unsigned a_lbp_hist_size,float **a_res_data,unsigned &a_res_width,unsigned &a_res_height);

bool compute_cooccurence_matrices(IplImage *a_img,unsigned a_x_step,unsigned a_y_step,unsigned a_cooc_block_side,unsigned a_cooc_bin_size,unsigned a_cooc_mat_size,unsigned **a_res_data,unsigned &a_res_width,unsigned &a_res_height);

const unsigned c_haralick_feature_size = 5;
enum {
   c_haralick_energy = 0,
   c_haralick_entropy,
   c_haralick_contrast,
   c_haralick_correlation,
   c_haralick_homogenity,
};

bool compute_haralick_features_from_cooccurence_matrices(float *a_cooc_mat_data,float **a_haralick_data,unsigned a_cooc_mat_cnt,unsigned a_cooc_mat_side);

void normalize_feature_vectors(float *a_data_ptr,unsigned a_vector_cnt,unsigned a_vector_size);
void normalize_feature_vectors_UINT_to_FLOAT(unsigned *a_data_ptr,float *a_trg_data_ptr,unsigned a_vector_cnt,unsigned a_vector_size);
bool image_from_vectors(float *a_data_ptr,unsigned a_vector_cnt,unsigned a_vector_size,IplImage *a_img);

enum {
   ifv_SUM = 0,
   ifv_MAX,
   ifv_MIN,
};

bool image_from_vectors_op(float *a_data_ptr,unsigned a_vector_cnt,unsigned a_vector_size,unsigned a_operation,unsigned a_bin_idx,IplImage *a_img);

// - temporary functions -
bool lbp_seg_test(IplImage *a_src);
bool cooc_seg_test(IplImage *a_src);

int main(int argc,char **argv);

