#!/usr/bin/python

import sys,os
import libxml2
from __base import *
from __pgsql import *

SERVER_ADDR = "http://localhost:9081"

class resource_s:
   def __init__(self):
      pass

# ------------------------------------------------------------------------------
def f_process_resource_list_xml_file(a_file):
   resource_lst = []#{{{
   xml_doc = libxml2.parseDoc(a_file.read())

   xml_node_0 = xml_doc.children
   while xml_node_0 is not None:
      xml_node_1 = xml_node_0.children
      while xml_node_1 is not None:
         if xml_node_1.name == "result":
            xml_node_2 = xml_node_1.children
            while xml_node_2 is not None:
               if xml_node_2.type == "element":
                  resource = resource_s()

                  xml_node_2_prop = xml_node_2.properties
                  while xml_node_2_prop is not None:
                     if xml_node_2_prop.name == "uri":
                        resource.uri = xml_node_2_prop.content
                     elif xml_node_2_prop.name == "type":
                        resource.type = xml_node_2_prop.content
                     elif xml_node_2_prop.name == "state":
                        resource.state = xml_node_2_prop.content

                     xml_node_2_prop = xml_node_2_prop.next
                  
                  resource_lst.append(resource)

               xml_node_2 = xml_node_2.next
         xml_node_1 = xml_node_1.next
      xml_node_0 = xml_node_0.next

   xml_doc.freeDoc()
   return resource_lst#}}}

# ------------------------------------------------------------------------------
def f_retrieve_resources_data(a_resource_lst):
   for resource in a_resource_lst:
      if resource.state == "processed":
         retrieve_cmd = "curl -G %s/%s?uri=%s >> %ss/%s 2> /dev/null" % (SERVER_ADDR,resource.type,resource.uri,resource.type,resource.uri)
         f_execute(retrieve_cmd)
   return True

# ------------------------------------------------------------------------------

#car_in_water - OBJECT in SEGMENT
#car_in_fire - OBJECT in SEGEMNT
#fire - SEGMENT TYPE || (OBJECT in SEGMENT)
#flood - SEGMENT TYPE
#man_in_water - OBJECT in SEGMENT

query_tuple = (
   (
      "car_in_water",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=water\\&object_type=car_side",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=water\\&object_type=car_back",
   ),
   (
      "car_in_fire",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=fire\\&object_type=car_side",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=fire\\&object_type=car_back",
   ),
   (
      "man_in_water",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=water\\&object_type=pedestrian",
      "<fire>",
      "and not",
      "query?q=getSegments\\&resource_uri=%s",
   ),
   (
      "fire",
      "<fire>",
      "or",
      "query?q=getSegments\\&resource_uri=%s",
   ),
   ( 
      "flood",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=water\\&object_type=car_side",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=water\\&object_type=car_back",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=water\\&object_type=traffic_sign",
      ">1</result>",
      "or",
      "query?q=isObjectInSegment\\&resource_uri=%s\\&segment_type=water\\&object_type=pedestrian",
      "<fire>",
      "and not",
      "query?q=getSegments\\&resource_uri=%s",
   )
)

# ------------------------------------------------------------------------------
def f_test_queries(a_resource_lst):
   queries_results = []

   #DEBUG_resource_cnt = len(resource_lst)
   #DEBUG_resource_idx = 0

   for resource in resource_lst:
      queries_result = []

      for query_descr in query_tuple:
         query_result = False

         q_name = query_descr[0]
         #q_test = query_descr[1]

         q_idx = 1
         while q_idx < len(query_descr):
            q_test = query_descr[q_idx]
            q_idx += 1
            q_operator = query_descr[q_idx]
            q_idx += 1

            query_cmd = "curl -G %s/%s 2> /dev/null" % (SERVER_ADDR,query_descr[q_idx] % resource.uri)
            q_idx += 1
            
            query_result_f = f_pipe_execute(query_cmd)

            q_test_result = False
            for line in query_result_f:
               if q_test in line:
                  q_test_result = True
                  break

            if q_operator == "or":
               query_result = query_result or q_test_result
            elif q_operator == "and not":
               query_result = query_result and (not q_test_result)
            else:
               assert 0

            query_result_f.close()

         queries_result.append(query_result)

      queries_results.append(queries_result)

      #DEBUG_resource_idx += 1
      #print "Progress: %d/%d" % (DEBUG_resource_idx,DEBUG_resource_cnt)

   return queries_results

# ------------------------------------------------------------------------------
def f_print_successfull_queries(a_resource_lst,a_queries_results):
   assert len(a_resource_lst) == len(a_queries_results)

   r_idx = 0
   while r_idx < len(a_resource_lst):
      queries_result = a_queries_results[r_idx]
      q_idx = 0
      while q_idx < len(queries_result):
         if queries_result[q_idx]:
            print "URI: %s QUERY: %s" % (a_resource_lst[r_idx].uri,query_tuple[q_idx][0])
         q_idx += 1

      r_idx += 1

# ------------------------------------------------------------------------------
def f_retrieve_sorted_by_queries_results(a_resource_lst,a_queries_results):

   # - remove old results -
   f_execute("rm -rf results;mkdir results")

   #{
   mkdir_cmd = "mkdir "
   for query_descr in query_tuple:
      mkdir_cmd += "results/%s " % query_descr[0]
   f_execute(mkdir_cmd)
   #}

   #{
   r_idx = 0
   while r_idx < len(a_resource_lst):
      resource = a_resource_lst[r_idx]
      downloaded = False
      queries_result = a_queries_results[r_idx]

      #{
      q_idx = 0
      while q_idx < len(queries_result):
         if queries_result[q_idx]:
            if not downloaded:
               donwload_cmd = "curl -G %s/%s?uri=%s > resource.tmp 2> /dev/null" % (SERVER_ADDR,resource.type,resource.uri)
               f_execute(donwload_cmd)
               downloaded = True

            copy_cmd = "cp resource.tmp results/%s/%s" % (query_tuple[q_idx][0],resource.uri)
            f_execute(copy_cmd)

         q_idx += 1
      #}

      r_idx += 1
   #}

# ------------------------------------------------------------------------------
def f_DEBUG_remove_videos(a_resource_lst):
   resource_lst = []
   for resource in a_resource_lst:
      if resource.type != "video":
         resource_lst.append(resource)
   
   return resource_lst

# = PROGRAM START =============================================

# - retrieve resource list -
resource_list_cmd = "curl -G %s/query?q=getResourceList 2> /dev/null" % SERVER_ADDR
resource_list_f = f_pipe_execute(resource_list_cmd)
resource_lst = f_process_resource_list_xml_file(resource_list_f)
resource_list_f.close()

# FIXME debug
resource_lst = f_DEBUG_remove_videos(resource_lst)

# - retrieve resource data -
# f_retrieve_resources_data(resource_lst)

# - test queries -
queries_results = f_test_queries(resource_lst)

# - print queries results -
f_print_successfull_queries(resource_lst,queries_results)

# - retrieve resources sorted by queries results -
f_retrieve_sorted_by_queries_results(resource_lst,queries_results)

