#!/usr/bin/python

from __base import *
from __pgsql import *
import time

def f_process_queue():

   # FUNCTION:
   #    - Endless loop X
   #       - find video - state "uploaded" X
   #          - run binary splitting video to frames, set frame count to fixed value! (update later)
   #                - change state to "in_process" 
   #             - retrieve image names, update video image count
   #             - insert frames, as uploaded image s to database (set video_id)
   #          - if something goes wrong:
   #             - change video state to "invalid"

   while True:
      f_pgsql_execute("SELECT id,uri,exp_time,exp_loc,frame_step FROM videos WHERE state=%d ORDER BY id LIMIT 1" % VIDEO_state_uploaded)

      if (db_cursor.rowcount != 0):
         video_res = db_cursor.fetchone()

         # - process result of query -
         video_id = int(video_res[0])
         video_uri = video_res[1]

         video_exp_time = video_res[2]
         if video_exp_time == None:
            video_exp_time = "NULL"

         video_exp_loc = video_res[3]
         if video_exp_loc == None:
            video_exp_loc = "NULL"

         video_frame_step = int(video_res[4])

         # - process video -
         process_cmd = "%s/process_video.py %d '%s' '%s' '%s' %d" % (BASE_DIR,video_id,video_uri,video_exp_time,video_exp_loc,video_frame_step)
         result = f_execute(process_cmd)

         # - check status -
         if result != 0:
            err_msg("Failed to process video, uri: \"%s\", exited with status: %d" % (video_uri,result))

            # - update video state to "invalid" -
            f_pgsql_execute("UPDATE videos SET state=%d WHERE id=%d" % (VIDEO_state_invalid,video_id))
            if db_cursor.rowcount != 1:
               f_pgsql_database_error()

            f_pgsql_commit();

      else:
         time.sleep(1.0)

# - PROGRAM START - ============================================================

f_process_queue()
f_pgsql_release_database(0)

