
#include "main.h"

int main(int argc,char **argv)
{
   if (argc < 3) {
      fprintf(stderr,"At least two arguments are expected: <video_file> <target_directory> [<frame_step>]\n");
      return 1;
   }
   
   const char *video_file = argv[1];
   const char *target_directory = argv[2];
   int frame_step = -1;
   
   if (argc >= 4) {
      frame_step = atoi(argv[3]);
   }

   CvCapture *capture = NULL;
   IplImage *frame = NULL;

   capture = cvCaptureFromFile(video_file);
   if (capture == NULL) {
      fprintf(stderr,"Cannot open video file \"%s\"\n",video_file);
      return 1;
   }

   int frame_count = (int)cvGetCaptureProperty(capture,CV_CAP_PROP_FRAME_COUNT);
   if (frame_step <= 0) {
      frame_step = frame_count/10;
   }
   else {
      if (frame_step >= frame_count) {
         fprintf(stderr,"Frame step must be lesser than count of video frames\n");
         cvReleaseCapture(&capture);
         return 1;
      }
   }

   // - print frame_step to stdout -
   printf("Frame_step: %d\n",frame_step);
   fflush(stdout);

   // - file name -
   const size_t c_fn_max_size = 1024;
   char fn[c_fn_max_size];

   char *fn_v_ptr;
   char *fn_i_ptr;
   size_t fn_i_max_size;

   {
      size_t target_directory_length = strlen(target_directory);
      fn_v_ptr = fn + target_directory_length;
      strncpy(fn,target_directory,c_fn_max_size);
      strncpy(fn_v_ptr,basename(video_file),c_fn_max_size - target_directory_length);
      size_t fn_wi_length = strlen(fn);

      fn_i_ptr = fn + fn_wi_length;
      fn_i_max_size = c_fn_max_size - fn_wi_length;
   }

   do {
      int f_count = 0;
      while((++f_count < frame_step) && cvGrabFrame(capture)) {}
      if (f_count < frame_step) break;

      frame = cvRetrieveFrame(capture);

      if (frame != NULL) {
         int pos_frames = (int)cvGetCaptureProperty(capture,CV_CAP_PROP_POS_FRAMES);
         int pos_msec = (int)cvGetCaptureProperty(capture,CV_CAP_PROP_POS_MSEC);

         // - save video frame as image -
         snprintf(fn_i_ptr,fn_i_max_size,"_%d.jpg",pos_frames);
         cvSaveImage(fn,frame);

         // - print image name to standard output -
         printf("%d:%s:\n",pos_msec,fn_v_ptr);
         fflush(stdout);
      }
   } while(1);

   cvReleaseCapture(&capture);

   return 0;
}

