
/*
 * File:   main.cpp
 * Author: onin
 *
 * Created on 26. duben 2009, 23:27
 */

#include <opencv/cv.h>
#include <opencv/cxcore.h>
#include <opencv/cxtypes.h>
#include <opencv/highgui.h>

#include <stdlib.h>
#include <iostream>
#include <map>
#include <dirent.h>

#include "config.h"
#include "areas/area.h"
#include "classifier.h"
#include "debug.h"


using namespace areaClsf;

/**
 * Entry point of program - just executes classification on couple of images.
 */
int main (int argc, char** argv)
{
	// check command line arguments
	if (argc != 5) {
		std::cerr << "4 arguments expected." << std::endl;
		std::cerr<< "./surface-classification <config_path> <input_img_path> <input_segment_img_path> <output_segment_img_path>" << std::endl;
		exit(EXIT_FAILURE);
	}

	std::string cfgPath     = argv[1];
	std::string inImgPath   = argv[2];
	std::string inSegmPath  = argv[3];
	std::string outSegmPath = argv[4];

	// load config file
	Config *cfg = Config::GetInstance();
	try {
		cfg->Load(cfgPath);
	} catch (CfgParseFailedException e) {
    std::cerr << e.what() + e.GetReason() << std::endl;
		exit(EXIT_FAILURE);
  }
	TAreasConfig areas = cfg->GetAreas();

	// initialize classifier class
	Classifier::Initialize(areas, inImgPath, inSegmPath, outSegmPath);

#if(DEBUG)
	// create a window
	cvNamedWindow("origWin", CV_WINDOW_AUTOSIZE);//erase
	cvMoveWindow("origWin", 0, 0);
  cvNamedWindow("resultWin", CV_WINDOW_AUTOSIZE);//erase
	cvMoveWindow("resultWin", 800, 0);
#endif

	// open source frame
	IplImage* imgSrc = NULL;

#if(DEBUG)
	std::cout << "Frame name: " << inImgPath << " -----------------------------------" << std::endl;
#endif

	if ((imgSrc = cvLoadImage(inImgPath.c_str())) == NULL) {
		std::cerr << "Unable to open image " << inImgPath << "." << std::endl;
		exit(EXIT_FAILURE);
	}

#if(DEBUG)
	// show the frame
	cvShowImage("origWin", imgSrc);//erase
	// wait for a key
	//cvWaitKey(0);
#endif

	// create new classifier for frame
	Classifier* classifier = new Classifier();
	// classify all desired area types
	classifier->Classify();
	delete classifier;

#if(DEBUG)
	std::cout << "Classifier done." << std::endl;
#endif

	// release frame
	cvReleaseImage(&imgSrc);

#if(DEBUG)
	// destroy the window
	cvDestroyWindow("origWin");
	cvDestroyWindow("resultWin");
#endif

  return (EXIT_SUCCESS);
}
