/* 
 * File:   config.h
 * Author: onin
 *
 * Created on 27. duben 2009, 22:54
 */

#ifndef _CONFIG_H
#define	_CONFIG_H

#include <opencv/cv.h>

#include <confuse.h>
#include <string>
#include <map>
#include <iostream>

namespace areaClsf {

	//<editor-fold defaultstate="collapsed" desc="Typedefs">
	/* area-types types */
	typedef enum {
		A_GRASS,
		A_SKY,
		A_PVMT,
		A_WATER,
                A_FIRE
	} EArea;

	typedef struct {
		uchar r, g, b, a;
	} TMarkColor;

	typedef struct {
            std::string name;
            TMarkColor markColor;
            float weight;
            float threshold;
	} TArea;

	typedef std::map<EArea, TArea> TAreasConfig; // area - data
	//</editor-fold>
	;//semicolor here because of Netbeans code folding bug
	//<editor-fold defaultstate="collapsed" desc="CfgParseFailedException">
	/**
	 * Thrown when parsing of any config files fails.
	 */
	class CfgParseFailedException: public std::exception
	{
		public:
			CfgParseFailedException (std::string reason) throw ();
			virtual ~CfgParseFailedException () throw ();
			virtual const char* what() const throw ();
			std::string GetReason ();

		private:
			std::string reason;
	};
	//</editor-fold>

	/**
	 * Singleton class looking after config files parsing.
	 * Stores the parsed config data in own data structures.
	 */
	class Config {

		public:
			static Config* GetInstance ();
			virtual ~Config ();
			void Load (std::string areasCfgPath);
			TAreasConfig GetAreas ();
			static std::string GetAreaName (EArea area);

		protected:
			Config ();// protected constructor

		private:
			static Config *instance; // pointer to the only instance
			static std::map<std::string, EArea> areasEnum;     // area-type name - area-type number
			TAreasConfig areas;      // structure with info about area types which should be classified
	};

}//namespace areaClsf

#endif	/* _CONFIG_H */

