/* 
 * File:   classifier.h
 * Author: onin
 *
 * Created on 28. duben 2009, 19:56
 */

#ifndef _CLASSIFIER_H
#define	_CLASSIFIER_H

#include <opencv/cxtypes.h>
#include <opencv/highgui.h>

#include <map>
#include <string>
#include <iostream>
#include "config.h"

namespace areaClsf {

	//<editor-fold defaultstate="collapsed" desc="Typedefs">
	typedef std::map<EArea, float> TMapAreaProbab; // area-type - probability

	typedef std::map<double, TMapAreaProbab> TMapSegProbabs; // segment color - probabilities

	typedef struct {
		IplImage* imgSeg;
		TMapSegProbabs segProbabs;
	} TMethodClassifData;

	//</editor-fold>
	;//semicolor here because of Netbeans code folding bug
	//<editor-fold defaultstate="collapsed" desc="NotInitializedException">
	/**
	 * Thrown when constructor of Classifier class is called before Initialize
	 * method has been called.
	 */
	class NotInitializedException: public std::exception
	{
		public:
			virtual const char* what() const throw();
	};
	//</editor-fold>

	/**
	 * Provides classification services for single image (and set of segmented
	 * images via different methods). Works with configuration data from Config
	 * class. Utilizes "find" methods of individual area-types classes and processes
	 * their results to compute overall classification result.
	 */
	class Classifier
	{
		public:
			static void Initialize (TAreasConfig areas, std::string dirImg, std::string dirSegm, std::string dirRes);
			Classifier ();
			Classifier (const Classifier& orig);
			virtual ~Classifier ();
			void Classify ();

		private:
			static bool initialized;         // flag whether Initialize methods has been called
			static TAreasConfig areas;       // area-types config data structure
			static std::string inImgPath;    // path to original image
                        static std::string inSegmPath;   // path to input segmented image (with possibly non-unique segment colors)
                        static std::string outSegmPath;  // path to output segmented image (with unique segment colors)
			IplImage *frame;                 // processed image itself
			TMethodClassifData data;         // hierarchical data structure with auxiliary classification data
			void IdentifySegments ();
			void FitFrameSize (IplImage **img);
	};

}//namespace areaClsf

#endif	/* _CLASSIFIER_H */

