/* 
 * File:   pavement.cpp
 * Author: onin
 * 
 * Created on 3. květen 2009, 22:19
 */

#include "pavement.h"

namespace areaClsf {

	/**
	 * Default constructor.
	 */
	Pavement::Pavement ()
	{
	}

	/**
	 * Copy constructor.
	 */
	Pavement::Pavement (const Pavement& orig)
	{
	}

	/**
	 * Destructor.
	 */
	Pavement::~Pavement ()
	{
	}

	/**
	 *
	 */
	TMapProbab Pavement::Find (IplImage *orig, IplImage *seg)
	{
		// convert image to HSV color space
		IplImage *hsv = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 3);
		cvCvtColor(orig, hsv, CV_BGR2HSV);
		// split respective channels
		IplImage *hChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *sChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *valChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		cvSplit(hsv, hChnl, sChnl, valChnl, NULL);

		// convert image to YUV color space
		IplImage *yuv = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 3);
		cvCvtColor(orig, yuv, CV_BGR2YCrCb);
		// split respective channels
		IplImage *yChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *uChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *vChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		cvSplit(yuv, yChnl, uChnl, vChnl, NULL);

		IplImage *tmpProb = static_cast<IplImage*>(cvClone(orig));//erase

		// maps for sum of pavement occurence probability and count of pixels in each segment
		std::map<double, float> sum, count;

		// for each pixel do
		for (int y = 0; y < seg->height; y++) {
			for (int x = 0; x < seg->width; x++) {

				// saturation probability (is the saturation low)?
				const uchar sat0 = 0;
				const float sigmaSat = 40.0;
				float pSaturation = exp(-pow(((sChnl->imageData + sChnl->widthStep*y)[x] - sat0) / sigmaSat, 2));

				// color probability (is it black or gray?)
				const uchar u0 = 128;
				const float sigmaU = 10.0;
				const uchar v0 = 128;
				const float sigmaV = 10.0;
				uchar uComponent = (uChnl->imageData + uChnl->widthStep*y)[x];
				uchar vComponent = (vChnl->imageData + vChnl->widthStep*y)[x];
				float pColor = exp(-(pow((uComponent-u0) / sigmaU, 2) + pow((vComponent-v0) / sigmaV, 2)));

				// overall pavement probability
				float pOverallThreshold = 0.15;
				//float pOverall = (pSaturation + pColor) * pColor / 2;
				float pOverall = sqrt(pSaturation) * pColor;

				// save the probability
				double color = cvGet2D(seg, y, x).val[0];

				sum[color] += pOverall;
				count[color] ++;
				(tmpProb->imageData + tmpProb->widthStep*y)[3*x] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+1] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+2] = (int)(128 * pOverall);//erase

			}
		}

		// release auxiliary images
		cvReleaseImage(&yChnl);
		cvReleaseImage(&uChnl);
		cvReleaseImage(&vChnl);
		cvReleaseImage(&yuv);
		cvReleaseImage(&hChnl);
		cvReleaseImage(&sChnl);
		cvReleaseImage(&valChnl);
		cvReleaseImage(&hsv);

#if(DEBUG)
		//cvShowImage("resultWin", tmpProb); cvWaitKey(0);//erase
		cvSaveImage(this->frameName.c_str(), tmpProb);
#endif

		cvReleaseImage(&tmpProb);

		TMapProbab probabs;
		for (std::map<double, float>::iterator i = sum.begin(); i != sum.end(); ++i) {
			probabs[i->first] = sum[i->first] / count[i->first];
			//std::cout << int(i->first) << ": " << sum[i->first] << " - " << count[i->first] << std::endl;//erase
		}

		return probabs;
	}

}//namespace areaClsf
