/* 
 * File:   grass.cpp
 * Author: onin
 * 
 * Created on 27. duben 2009, 22:51
 */

#include "grass.h"

namespace areaClsf {

	/**
	 * Default constructor.
	 */
	Grass::Grass ()
	{
	}

	/**
	 * Copy constructor.
	 */
	Grass::Grass (const Grass& orig)
	{
	}

	/**
	 * Destructor.
	 */
	Grass::~Grass ()
	{
	}

	/**
	 *
	 */
	TMapProbab Grass::Find (IplImage *orig, IplImage *seg)
	{
		// convert image to YUV color space
		IplImage *yuv = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 3);
		cvCvtColor(orig, yuv, CV_BGR2YCrCb);
		// split respective channels
		IplImage *yChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *uChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *vChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		cvSplit(yuv, yChnl, uChnl, vChnl, NULL);

		IplImage *tmpProb = static_cast<IplImage*>(cvClone(orig));//erase

		// maps for sum of grass occurence probability and count of pixels in each segment
		std::map<double, float> sum, count;
		//float maxP = 0;//erase
		//float minP = 100000000;//erase
		// for each pixel do
		for (int y = 0; y < seg->height; y++) {
			for (int x = 0; x < seg->width; x++) {

				// color probability (is it green?)
				// constants and algorithm from: http://www.freepatentsonline.com/6832000.html
				float pColorThreshold = 0.012;
				const uchar y0 = 82;
				const float sigmaY = 120.0;
				const uchar u0 = 0;
				const float sigmaU = 90.0;
				const uchar v0 = 0;
				const float sigmaV = 80.0;
				uchar yComponent = (yChnl->imageData + yChnl->widthStep*y)[x];
				uchar uComponent = (uChnl->imageData + uChnl->widthStep*y)[x];
				uchar vComponent = (vChnl->imageData + vChnl->widthStep*y)[x];
				float pColor = exp(-(pow((yComponent-y0) / sigmaY, 2) + pow((uComponent-u0) / sigmaU, 2) + pow((vComponent-v0) / sigmaV, 2)));
				pColor = pColor < pColorThreshold ? 0.0 : pColor;

				// texture probability (is there some texture?)
				// algorithm from http://vca.ele.tue.nl/publications/data/Zafarifar2008a.pdf
				float pTextureThreshold = 0.3;
				float noiseThreshold = 0;
				uchar yCur = (yChnl->imageData + yChnl->widthStep*y)[x];
				uchar yTop = (yChnl->imageData + yChnl->widthStep*((yChnl->height+y-1) % yChnl->height))[x];
				uchar yBottom = (yChnl->imageData + yChnl->widthStep*((y+1) % yChnl->height))[x];
				uchar yLeft = (yChnl->imageData + yChnl->widthStep*y)[(yChnl->width+x-1) % yChnl->width];
				uchar yRight = (yChnl->imageData + yChnl->widthStep*y)[(x+1) % yChnl->width];
				float pTexture = (fabs(yCur - (yTop+yBottom)/2.0) + fabs(yCur - (yLeft+yRight)/2.0) - noiseThreshold) / 512/* normalization */;
				pTexture = pTexture > pTextureThreshold ? 0.0 : pTexture;
				//std::cout<< pTexture << std::endl;//erase

				// overall grass probability
				float pOverall = sqrt(pColor) * pTexture;

				//if (pOverall > maxP) maxP = pOverall;//erase
				//if (pOverall < minP) minP = pOverall;//erase

				// save the probability
				double color = cvGet2D(seg, y, x).val[0];

				/* try to show respective segments
				if (count.find(color) == count.end()) {
					// color not found in count map - new color
					std::cout << "New color " << color << std::endl;//erase
					IplImage *tmp = static_cast<IplImage*>(cvClone(orig));//erase
					for (int y = 0; y < tmp->height; y++) {
						for (int x = 0; x < tmp->width; x++) {
							if (cvGet2D(seg, y, x).val[0] == color) {
								(tmp->imageData + tmp->widthStep*y)[3*x] = 0;
								(tmp->imageData + tmp->widthStep*y)[3*x+1] = 255;
								(tmp->imageData + tmp->widthStep*y)[3*x+2] = 0;
							}
						}
					}
					cvShowImage("resultWin", tmp); cvWaitKey(0);//erase
					cvReleaseImage(&tmp);
				}*/
				sum[color] += pOverall;
				count[color] ++;
				(tmpProb->imageData + tmpProb->widthStep*y)[3*x] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+1] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+2] = (int)(100 * 255 * pOverall);//erase
				
			}
		}

		//std::cout << "minP: " << minP << ", maxP: " << maxP << std::endl;//erase

		// release auxiliary images
		cvReleaseImage(&yChnl);
		cvReleaseImage(&uChnl);
		cvReleaseImage(&vChnl);
		cvReleaseImage(&yuv);

#if(DEBUG)
		//cvShowImage("resultWin", tmpProb); cvWaitKey(0);//erase
		cvSaveImage(this->frameName.c_str(), tmpProb);
#endif

		cvReleaseImage(&tmpProb);

		TMapProbab probabs;
		for (std::map<double, float>::iterator i = sum.begin(); i != sum.end(); ++i) {
			probabs[i->first] = sum[i->first] / count[i->first];
			//std::cout << int(i->first) << ": " << sum[i->first] << " - " << count[i->first] << std::endl;//erase
		}

		return probabs;
	}

}//namespace areaClsf
