/* 
 * File:   Fire.cpp
 * Author: ipribyl
 * 
 * Created on 30. září 2010, 14:43
 */

#include "fire.h"

namespace areaClsf {

	/**
	 * Default constructor.
	 */
	Fire::Fire()
	{
	}

	/**
	 * Copy constructor.
	 */
	Fire::Fire(const Fire& orig)
	{
	}

	/**
	 * Destructor.
	 */
	Fire::~Fire()
	{
	}

	/**
	 * Algorithm implemented according to paper "An Early Fire-Detection Method
	 * Based on Image Processing"
	 * http://ieeexplore.ieee.org/xpls/abs_all.jsp?arnumber=1421401&tag=1
	 */
	TMapProbab Fire::Find (IplImage *orig, IplImage *seg)
	{
		// convert image to HSV color space
		IplImage *hsv = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 3);
		cvCvtColor(orig, hsv, CV_BGR2HSV);
		// split respective channels
		IplImage *hChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *sChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		IplImage *vChnl = cvCreateImage(cvGetSize(seg), IPL_DEPTH_8U, 1);
		cvSplit(hsv, hChnl, sChnl, vChnl, NULL);
		cvReleaseImage(&vChnl);
		cvReleaseImage(&hChnl);
		cvReleaseImage(&hsv);
		
		IplImage *tmpProb = static_cast<IplImage*>(cvClone(orig));//erase

		// maps for sum of grass occurence probability and count of pixels in each segment
		std::map<double, float> sum, count;
		// for each pixel do
		for (int y = 0; y < seg->height; y++) {
			for (int x = 0; x < seg->width; x++) {

				uchar bComponent = (orig->imageData  + orig->widthStep*y) [3*x+0];
				uchar gComponent = (orig->imageData  + orig->widthStep*y) [3*x+1];
				uchar rComponent = (orig->imageData  + orig->widthStep*y) [3*x+2];
				uchar sComponent = (sChnl->imageData + sChnl->widthStep*y)[x];

				uchar redThreshold = 200;  // recommended 115 - 135
				float redThreshrange = 40.0;
				float colorRange = 32.0;
				uchar satThreshold = 70;   // recommended 55 - 65
				float satRange = 64.0;


				float pRed = (rComponent > redThreshold ? 1.0 : 0.0);
				//float pRed        = redThreshrange / (rComponent - redThreshold + redThreshrange/2);
				//pRed = (pRed < 0.0 ? 0.0 : pRed); pRed = (pRed > 1.0 ? 1.0 : pRed);
				//float pRG = ((gComponent > bComponent) && (rComponent >= gComponent) ? 1.0 : 0.0);
				float pRG = (((rComponent - gComponent) / (colorRange/2)) + 1.0) / 2;
				//float pRG = (rComponent >= gComponent ? 1.0 : 0.0);
				pRG = (pRG < 0.0 ? 0.0 : pRG); pRG = (pRG > 1.0 ? 1.0 : pRG);
				float pRS = (((gComponent - bComponent) / (colorRange/2)) + 1.0) / 2;
				pRS = (pRS < 0.0 ? 0.0 : pRS); pRS = (pRS > 1.0 ? 1.0 : pRS);
				float pColor = pRG * pRS;
				//float pSaturation = (sComponent >= ((255 - rComponent) * satThreshold / redThreshold) ? 1.0 : 0.0);
				float pSaturation = (((sComponent - ((255 - rComponent) * satThreshold / redThreshold)) / (satRange/2)) + 1.0) / 2;
				pSaturation = (pSaturation < 0.0 ? 0.0 : pSaturation); pSaturation = (pSaturation > 1.0 ? 1.0 : pSaturation);

				// overall fire probability
				float pFire = pRed * pColor * pSaturation;
				pFire = (pFire < 0.0 ? 0.0 : pFire); pFire = (pFire > 1.0 ? 1.0 : pFire);

				// save the probability
				double color = cvGet2D(seg, y, x).val[0];
				//if(color == 0.0) continue;
				sum[color] += pFire;
				count[color] ++;
				(tmpProb->imageData + tmpProb->widthStep*y)[3*x] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+1] = (tmpProb->imageData + tmpProb->widthStep*y)[3*x+2] = (int)(255 * pFire);//erase

			}
		}

		cvReleaseImage(&sChnl);
		cvReleaseImage(&hsv);

#if(DEBUG)
		//cvShowImage("resultWin", tmpProb); cvWaitKey(0);//erase
		cvSaveImage(this->frameName.c_str(), tmpProb);
#endif

		cvReleaseImage(&tmpProb);

		TMapProbab probabs;
		for (std::map<double, float>::iterator i = sum.begin(); i != sum.end(); ++i) {
			probabs[i->first] = sum[i->first] / count[i->first];
		}
		
		return probabs;
	}

}//namespace areaClsf
