
@begin
   include "mem_check.h"
@end

#if MEM_CHECK == ENABLE

/*
 * methods of generated structures
 */

// -- mc_block_s --
@begin
   methods mc_block_s
@end

// -- mc_block_set_s --
@begin
   methods mc_block_set_s
@end

// -- mc_struct_s --
@begin
   methods mc_struct_s
@end

unsigned mc_struct_s::get_idx_by_location(void *a_location)
{/*{{{*/
   if (mc_block_set.first_idx == c_idx_not_exist) {
      return c_idx_not_exist;
   }

   unsigned idx = mc_block_set.first_idx;
   do {
      if (mc_block_set[idx].location == a_location) {
         return idx;
      }

      idx = mc_block_set.next_idx(idx);
   } while(idx != c_idx_not_exist);

   return c_idx_not_exist;
}/*}}}*/

void mc_struct_s::check()
{/*{{{*/

   // - print info about allocated memory -
   fprintf(stderr,"actually allocated memory: %4.3f KB\nallocated memory: %4.3f KB\nmax used memory: %4.3f KB\n",act_alloc_size/1024.0,alloc_size/1024.0,max_alloc_size/1024.0);

   // - test if all blocks was released -
   if (mc_block_set.first_idx == c_idx_not_exist) {
      return;
   }

   unsigned idx = mc_block_set.first_idx;
   do {
      mc_block_s &mc_block = mc_block_set[idx];

      fprintf(stderr,"MEM_CHECK: unreleased memory at: %lu, of size: %u\n",(unsigned long)mc_block.location,mc_block.size);
      free(mc_block.location);

      idx = mc_block_set.next_idx(idx);
   } while(idx != c_idx_not_exist);

}/*}}}*/

mc_struct_s mc_struct;
#endif

