
@begin
   include "main.h"
@end

int main(int argc,char **argv)
{
   mc_init();

   {
      if (argc != 4) {
         fprintf(stderr,"Expecting name of file, name of target directory, median parameter\n");
      }
      else {
         int median_value = atoi(argv[3]);
         if (median_value < 3 || median_value > 50) {
         }
         else {
            image_s img_src;
            image_s img_32U;
            image_s img_mask;

            img_src.init();
            img_32U.init();
            img_mask.init();

            if (!img_src.load_from_bmp_file(argv[1])) {return 1;}
            if (!img_32U.create(img_src.width,img_src.height,c_image_pixel_format_32U)) {return 1;}
            if (!img_32U.sg_convert_3X8U_to_32U(img_src)) {return 1;}

            // - median testing -
            {
               image_s img_med;
               img_med.init();
               img_med.create(img_32U);
               img_med.io_copy(img_32U);

               // - compute median -
               cassert(img_med.sg_rect_median(img_32U,median_value));

               img_32U.swap(img_med);
               img_med.clear();
            }

            unsigned value_cnt;
            if (!img_32U.sg_get_max_value_32U(value_cnt)) {return 1;}
            value_cnt += 1; // - value_cnt = max_value + 1 -

            bool *color_occ = (bool *)cmalloc(value_cnt*sizeof(bool));
            if (!img_32U.sg_get_color_occurrences(color_occ,value_cnt)) {return 1;}

            {
               string_s file_name;
               file_name.init();

               unsigned idx = 0;
               do {
                  if (color_occ[idx]) {
                     if (!img_mask.create(img_32U.width,img_32U.height,c_image_pixel_format_8U)) {return 1;}
                     if (!img_mask.sg_get_color_mask(img_32U,idx)) {return 1;}

                     file_name.setf("%sseg_%4.4u.bmp",argv[2],idx);
                     if (!img_mask.__convert_save(file_name.data)) {return 1;}
                  }
               } while(++idx < value_cnt);

               file_name.clear();
            }

            cfree(color_occ);

            img_mask.clear();
            img_32U.clear();
            img_src.clear();
         }
      }
   }

   mc_clear();

   return 0;
}


