
#ifndef __BITMAP_H
#define __BITMAP_H

@begin
   include "basic.h"
   include "mem_check.h"
@end

/*
 * definition of structure bitmap_s
 */

#pragma pack(1)
struct bmp_file_header_s
{
   short type;
   int size;
   short res_1;
   short res_2;
   int off_bits;
};
#pragma pack()

#pragma pack(1)
struct bmp_image_header_s
{
   int size;
   int width;
   int height;
   short planes;
   short bit_cnt;
   int compression;
   int image_size;
   int x_pel_per_meter;
   int y_pel_per_meter;
   int clr_used;
   int clr_important;
};
#pragma pack()

struct bitmap_s
{
   bmp_file_header_s fh;
   bmp_image_header_s ih;
   unsigned char *data;

   inline void init();
   inline void clear();

   /*!
    * \brief load bitmap from file
    */
   bool load_from_file(const char *a_file);

   /*!
    * \brief save bitmap to file
    */
   bool save_to_file(const char *a_file);
};

/*
 * inline methods of structure bitmap_s
 */

inline void bitmap_s::init()
{/*{{{*/
   data = NULL;
}/*}}}*/

inline void bitmap_s::clear()
{/*{{{*/
   if (data != NULL) {
      cfree(data);
      data = NULL;
   }
}/*}}}*/

#endif

