
#ifndef __SPEC_SEG_H
#define __SPEC_SEG_H

@begin
   include "basic.h"
   include "mem_check.h"
   include "structures.h"
   include "atomic.h"
   include "bitmap.h"
   include "image.h"
   include "segmentation.h"
@end

/*
 * basic definition and constants
 */

const unsigned c_spec_block_power_size = 4;

const unsigned c_radial_areas_cnt = 5;
const float c_radial_areas[] = {
   0.0f, 0.1f,
   0.1f, 0.2f,
   0.2f, 0.3f,
   0.3f, 0.4f,
   0.4f, 0.5f,
};

const unsigned c_angular_areas_cnt = 4;
const float c_angular_areas[] = {
   -0.125f*c_pi_number, 0.125f*c_pi_number,
   0.125f*c_pi_number, 0.375f*c_pi_number,
   0.375f*c_pi_number, 0.625f*c_pi_number,
   0.625f*c_pi_number, 0.875f*c_pi_number,
};

/*
 * definition of generated structures
 */

// -- ra_kernel_s --
@begin
   struct
   <
   unsigned:offset
   unsigned:target
   >
   ra_kernel_s;
@end

// -- ra_kernel_array_s --
@begin
   array<ra_kernel_s> ra_kernel_array_s;
@end

// -- spec_seg_s --
@begin
   struct
   <
   unsigned:block_power_size
   unsigned:block_size
   unsigned:block_size_d2

   unsigned:radial_cnt
   unsigned:angular_cnt

   bf_ptr:radial
   bf_ptr:angular

   unsigned:width
   unsigned:height
   unsigned:length
   bf_ptr:seg_data

   ra_kernel_array_s:ra_kernel_array
   >

   not_generate: init clear

   additions {
      inline void init();
      inline void clear();
      inline bool setup(unsigned a_block_power_size,unsigned a_radial_cnt,unsigned a_angular_cnt,const float *a_radial,const float *a_angular);

      bool initialize_area_values();
      bool compute_radial_and_angular_means(image_s &a_img,float *a_mean_vector);
      bool compute_spectral_features_data(image_s &a_img);

      void get_feature_parameters_string(string_s &a_fp_str);
      inline bool get_features(feature_data_s &a_fd);
      bool get_features_MASK(image_s &a_mask,feature_data_s &a_fd);
   }

   spec_seg_s;
@end

/*
 * inline methods of structure image_s
 */

// -- ra_kernel_s --
@begin
   inlines ra_kernel_s
@end

// -- ra_kernel_array_s --
@begin
   inlines ra_kernel_array_s
@end

// -- spec_seg_s --
@begin
   inlines spec_seg_s
@end

inline void spec_seg_s::init()
{/*{{{*/
   seg_data = NULL;
   ra_kernel_array.init();
}/*}}}*/

inline void spec_seg_s::clear()
{/*{{{*/
   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   ra_kernel_array.clear();
   init();
}/*}}}*/

inline bool spec_seg_s::setup(unsigned a_block_power_size,unsigned a_radial_cnt,unsigned a_angular_cnt,const float *a_radial,const float *a_angular)
{/*{{{*/
   block_power_size = a_block_power_size;

   block_size = 1 << block_power_size;
   block_size_d2 = block_size >> 1;

   radial_cnt = a_radial_cnt;
   angular_cnt = a_angular_cnt;

   radial = (float *)a_radial;
   angular = (float *)a_angular;

   return true;
}/*}}}*/

inline bool spec_seg_s::get_features(feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_SPECTRAL_FEATURES;

   // - generate feature_parameters string -
   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = width;
   a_fd.height = height;
   a_fd.fv_cnt = width*height;
   a_fd.fv_length = length;
   a_fd.fv_data = seg_data;
   seg_data = NULL;

   return true;
}/*}}}*/

#endif

