
#ifndef __LM_SEG_H
#define __LM_SEG_H

@begin
   include "basic.h"
   include "mem_check.h"
   include "structures.h"
   include "atomic.h"
   include "bitmap.h"
   include "image.h"
   include "segmentation.h"
@end

/*
 * basic definition and constants
 */

const unsigned c_lm_kernel_side_size = 5;
const unsigned c_lm_kernel_cnt = 6;
const float c_lm_kernels[] = {

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f,-1.0f,-1.0f,-1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 1.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,

    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 0.0f,-1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
    0.0f,-1.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 0.0f, 0.0f,
};

/*
 * definition of generated structures
 */

// -- lms_kernel_s --
@begin
   struct
   <
   unsigned:src_off
   unsigned:trg_off
   float:value
   >
   lms_kernel_s;
@end

// -- lms_kernel_array_s --
@begin
   array<lms_kernel_s> lms_kernel_array_s;
@end

// -- lm_seg_s --
@begin
   struct
   <
   unsigned:kernel_side_size
   unsigned:kernel_size
   unsigned:kernel_cnt
   bf_ptr:kernels

   unsigned:width
   unsigned:height
   unsigned:length
   bf_ptr:seg_data

   lms_kernel_array_s:lms_kernels
   >

   not_generate: init clear

   additions {
      inline void init();
      inline void clear();
      inline bool setup(unsigned a_kernel_side_size,unsigned a_kernel_cnt,const float *a_kernels);

      bool generate_convolution_kernels(image_s &a_img);
      bool compute_per_pixel_lm_data(image_s &a_img);

      void get_feature_parameters_string(string_s &a_fp_str);
      inline bool get_features(feature_data_s &a_fd);
      bool get_features_MASK(image_s &a_mask,feature_data_s &a_fd);
   }

   lm_seg_s;
@end

/*
 * inline methods of structure image_s
 */

// -- lms_kernel_s --
@begin
   inlines lms_kernel_s
@end

// -- lms_kernel_array_s --
@begin
   inlines lms_kernel_array_s
@end

// -- lm_seg_s --
@begin
   inlines lm_seg_s
@end

inline void lm_seg_s::init()
{/*{{{*/
   width = 0;
   height = 0;
   length = 0;
   seg_data = NULL;

   lms_kernels.init();
}/*}}}*/

inline void lm_seg_s::clear()
{/*{{{*/
   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   lms_kernels.clear();
   init();
}/*}}}*/

inline bool lm_seg_s::setup(unsigned a_kernel_side_size,unsigned a_kernel_cnt,const float *a_kernels)
{/*{{{*/
   kernel_side_size = a_kernel_side_size;
   kernel_size = kernel_side_size*kernel_side_size;
   kernel_cnt = a_kernel_cnt;
   kernels = (float *)a_kernels;

   return true;
}/*}}}*/

inline bool lm_seg_s::get_features(feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_LOCAL_MOMENTS_FEATURES;

   // - create feature_parameters string -
   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = width;
   a_fd.height = height;
   a_fd.fv_cnt = width*height;
   a_fd.fv_length = length;
   a_fd.fv_data = seg_data;
   seg_data = NULL;

   return true;
}/*}}}*/

#endif

