
@begin
   include "lbp_seg.h"
@end

/*
 * methods of generated structures
 */

// -- lbp_seg_s --
@begin
   methods lbp_seg_s
@end

bool lbp_seg_s::seg_lbp_compute_offset_and_multiplier_array(image_s &a_src,unsigned a_pattern_length,unsigned a_radius,ui_array_s &a_om_array)
{/*{{{*/
   unsigned radius_m2 = (a_radius << 1) + 1;

   if (a_src.pixel_format != c_image_pixel_format_8U || a_pattern_length < 1 || a_pattern_length > 32 || a_radius < 1 ||
      radius_m2 > a_src.width || radius_m2 > a_src.height) {
      return false;
   }

   unsigned s_pixel_step = a_src.pixel_step;
   unsigned s_line_size = a_src.image_data_ptr->line_bytes;

   // - blank offset and multiplier array -
   a_om_array.used = 0;

   // - create offset and multipliers array -
   unsigned p_idx = 0;
   do {
      float px = (((float)a_radius)*cos(c_2pi_number*(((float)p_idx)/a_pattern_length))) + a_radius;
      float py = (-((float)a_radius)*sin(c_2pi_number*(((float)p_idx)/a_pattern_length))) + a_radius;

      unsigned cpx = ((int)px);
      unsigned cpy = ((int)py);

      float rpx = px - cpx;
      float rpy = py - cpy;

      float rev_rpx = 1.0f - rpx;
      float rev_rpy = 1.0f - rpy;

      // - pixel offset -
      a_om_array.push(cpy*s_line_size + cpx*s_pixel_step);

      // - blend multipliers -
      a_om_array.push((unsigned)((rev_rpx*rev_rpy)*(UINT_MAX/UCHAR_MAX))); //0,0
      a_om_array.push((unsigned)((rpx*rev_rpy)*(UINT_MAX/UCHAR_MAX))); //1,0
      a_om_array.push((unsigned)((rev_rpx*rpy)*(UINT_MAX/UCHAR_MAX))); //0,1
      a_om_array.push((unsigned)((rpx*rpy)*(UINT_MAX/UCHAR_MAX))); //1,1

   } while(++p_idx < a_pattern_length);

   return true;
}/*}}}*/

bool lbp_seg_s::seg_lbp_compute_LBP_by_offset_and_mutiplier_array(image_s &a_src,image_s &a_trg,unsigned a_pattern_length,unsigned a_radius,ui_array_s &a_om_array)
{/*{{{*/
   unsigned radius_m2 = (a_radius << 1) + 1;

   if (a_src.pixel_format != c_image_pixel_format_8U || a_trg.width != a_src.width || a_trg.height != a_src.height || a_pattern_length < 1 || a_radius < 1 || 
      radius_m2 >= a_trg.width || radius_m2 >= a_trg.height || a_om_array.used != a_pattern_length*5 ||
      !((a_trg.pixel_format == c_image_pixel_format_8U && a_pattern_length <= 8) || (a_trg.pixel_format == c_image_pixel_format_32U && a_pattern_length <= 32))) {
      return false;
   }

   // - compute local binary patterns -
   unsigned s_pixel_step = a_src.pixel_step;
   unsigned line_size = a_trg.image_data_ptr->line_bytes;
   unsigned s_line_size = a_src.image_data_ptr->line_bytes;
   unsigned image_ls = (a_trg.width - radius_m2)*a_trg.pixel_step;
   unsigned s_image_ls = (a_src.width - radius_m2)*s_pixel_step;

   unsigned char *ptr = a_trg.image_data_ptr->data + (a_trg.y_pos + a_radius)*line_size + (a_trg.x_pos + a_radius)*a_trg.pixel_step;
   unsigned char *ptr_end = ptr + ((a_trg.height - radius_m2) - 1)*line_size + (a_trg.width - radius_m2)*a_trg.pixel_step;
   unsigned char *s_ptr = a_src.image_data_ptr->data + a_src.y_pos*s_line_size + a_src.x_pos*s_pixel_step;

   // - offset to central pixel -
   unsigned s_center_offset = a_radius*s_line_size + a_radius*s_pixel_step;

   // - first bit for pattern rotation -
   unsigned first_bit = 0x01 << (a_pattern_length - 1);

   switch (a_trg.pixel_format) {
   case c_image_pixel_format_8U:
      {
         const unsigned char c_lbp_minimal_value_map[256] = // MAX - blank value
         {0,1,1,2,1,255,2,3,1,255,255,255,2,255,3,4,1,255,255,255,255,255,255,255,2,255,255,255,3,255,4,5,1,255,255,255,255,255,255,255,
         255,255,255,255,255,255,255,255,2,255,255,255,255,255,255,255,3,255,255,255,4,255,5,6,1,255,255,255,255,255,255,255,255,255,255,
         255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,2,255,255,255,255,255,255,255,255,255,255,
         255,255,255,255,255,3,255,255,255,255,255,255,255,4,255,255,255,5,255,6,7,1,2,255,3,255,255,255,4,255,255,255,255,255,255,255,
         5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
         255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,7,2,3,255,4,255,255,255,5,255,255,255,255,255,255,255,6,255,255,255,
         255,255,255,255,255,255,255,255,255,255,255,255,7,3,4,255,5,255,255,255,6,255,255,255,255,255,255,255,7,4,5,255,6,255,255,255,
         7,5,6,255,7,6,7,7,8};

         do {
            unsigned char *ptr_w_end = ptr + image_ls;
            do {
               unsigned result = 0;
      
               /* - compute binary pattern */
               unsigned *poa_ptr = a_om_array.data;
               unsigned *poa_ptr_end = poa_ptr + a_om_array.used;
      
               do {
                  unsigned char value = (s_ptr[*poa_ptr]*poa_ptr[1] + s_ptr[*poa_ptr + s_pixel_step]*poa_ptr[2] + s_ptr[*poa_ptr + 
                     s_line_size]*poa_ptr[3] + s_ptr[*poa_ptr + s_line_size + s_pixel_step]*poa_ptr[4]) >> (UINT_BIT - CHAR_BIT);
      
                  result <<= 1;
      
                  if (value > s_ptr[s_center_offset]) {
                     result |= 0x01;
                  }
               } while((poa_ptr += 5) < poa_ptr_end);
      
               *ptr = c_lbp_minimal_value_map[result];
      
            } while(s_ptr += s_pixel_step,(ptr += a_trg.pixel_step) < ptr_w_end);
      
            ptr += line_size - image_ls;
            s_ptr += s_line_size - s_image_ls;
         } while(ptr < ptr_end);
      }
      break;
   case c_image_pixel_format_32U:
      {
         do {
            unsigned char *ptr_w_end = ptr + image_ls;
            do {
               unsigned result = 0;
      
               /* - compute binary pattern */
               unsigned *poa_ptr = a_om_array.data;
               unsigned *poa_ptr_end = poa_ptr + a_om_array.used;
      
               do {
                  unsigned char value = (s_ptr[*poa_ptr]*poa_ptr[1] + s_ptr[*poa_ptr + s_pixel_step]*poa_ptr[2] + s_ptr[*poa_ptr + 
                     s_line_size]*poa_ptr[3] + s_ptr[*poa_ptr + s_line_size + s_pixel_step]*poa_ptr[4]) >> (UINT_BIT - CHAR_BIT);
      
                  result <<= 1;
      
                  if (value > s_ptr[s_center_offset]) {
                     result |= 0x01;
                  }
               } while((poa_ptr += 5) < poa_ptr_end);
      
               /* - rotate binary pattern to minimal value -*/
               unsigned min_result = result;
               unsigned idx = 0;
               do {
                  result = (result & 0x01)?((result >> 1) | first_bit):(result >> 1);
                  min_result = result < min_result?result:min_result;
               } while(++idx < a_pattern_length);
      
               *((unsigned *)ptr) = min_result;
      
            } while(s_ptr += s_pixel_step,(ptr += a_trg.pixel_step) < ptr_w_end);
      
            ptr += line_size - image_ls;
            s_ptr += s_line_size - s_image_ls;
         } while(ptr < ptr_end);
      }
      break;
   default:
      cassert(0);
   }

   return true;
}/*}}}*/

bool lbp_seg_s::seg_lbp_compute_LBP(image_s &a_src,image_s &a_trg,unsigned a_pattern_length,unsigned a_radius)
{/*{{{*/
   ui_array_s om_array;
   om_array.init();

   bool res;

   res = seg_lbp_compute_offset_and_multiplier_array(a_src,a_pattern_length,a_radius,om_array);
   if (!res) {
      om_array.clear();
      return false;
   }

   res = seg_lbp_compute_LBP_by_offset_and_mutiplier_array(a_src,a_trg,a_pattern_length,a_radius,om_array);
   if (!res) {
      om_array.clear();
      return false;
   }

   om_array.clear();
   return true;
}/*}}}*/

bool lbp_seg_s::seg_lbp_compute_LBP_by_offset_and_mutiplier_array_with_intensity(image_s &a_src,image_s &a_trg,image_s &a_intensity,unsigned a_pattern_length,unsigned a_radius,ui_array_s &a_om_array)
{/*{{{*/
   unsigned radius_m2 = (a_radius << 1) + 1;

   if (a_src.pixel_format != c_image_pixel_format_8U || a_intensity.pixel_format != c_image_pixel_format_8U || 
      width != a_intensity.width || height != a_intensity.height || width != a_src.width || height != a_src.height || 
      a_pattern_length < 1 || a_radius < 1 || radius_m2 >= width || radius_m2 >= height || a_om_array.used != a_pattern_length*5 ||
      !((a_trg.pixel_format == c_image_pixel_format_8U && a_pattern_length <= 8) || (a_trg.pixel_format == c_image_pixel_format_32U && a_pattern_length <= 32))) {
      return false;
   }

   // - compute local binary patterns -
   unsigned s_pixel_step = a_src.pixel_step;
   unsigned i_pixel_step = a_intensity.pixel_step;
   unsigned line_size = a_trg.image_data_ptr->line_bytes;
   unsigned s_line_size = a_src.image_data_ptr->line_bytes;
   unsigned i_line_size = a_intensity.image_data_ptr->line_bytes;
   unsigned image_ls = (width - radius_m2)*a_trg.pixel_step;
   unsigned s_image_ls = (a_src.width - radius_m2)*s_pixel_step;
   unsigned i_image_ls = (a_intensity.width - radius_m2)*i_pixel_step;

   unsigned char *ptr = a_trg.image_data_ptr->data + (a_trg.y_pos + a_radius)*line_size + (a_trg.x_pos + a_radius)*a_trg.pixel_step;
   unsigned char *ptr_end = ptr + ((height - radius_m2) - 1)*line_size + (width - radius_m2)*a_trg.pixel_step;
   unsigned char *s_ptr = a_src.image_data_ptr->data + a_src.y_pos*s_line_size + a_src.x_pos*s_pixel_step;
   unsigned char *i_ptr = a_intensity.image_data_ptr->data + a_intensity.y_pos*i_line_size + a_intensity.x_pos*i_pixel_step;

   // - offset to central pixel -
   unsigned s_center_offset = a_radius*s_line_size + a_radius*s_pixel_step;

   // - first bit for pattern rotation -
   unsigned first_bit = 0x01 << (a_pattern_length - 1);

   switch (a_trg.pixel_format) {
   case c_image_pixel_format_8U:
      {
         do {
            unsigned char *ptr_w_end = ptr + image_ls;
            do {
               unsigned result = 0;
     
               unsigned one_sum = s_ptr[s_center_offset];
               unsigned zero_sum = 0;
               unsigned one_cnt = 1;

               // - compute binary pattern -
               unsigned *poa_ptr = a_om_array.data;
               unsigned *poa_ptr_end = poa_ptr + a_om_array.used;
      
               do {
                  unsigned char value = (s_ptr[*poa_ptr]*poa_ptr[1] + s_ptr[*poa_ptr + s_pixel_step]*poa_ptr[2] + s_ptr[*poa_ptr + 
                     s_line_size]*poa_ptr[3] + s_ptr[*poa_ptr + s_line_size + s_pixel_step]*poa_ptr[4]) >> (UINT_BIT - CHAR_BIT);
      
                  result <<= 1;
      
                  if (value > s_ptr[s_center_offset]) {
                     result |= 0x01;
                     
                     one_sum += value;
                     one_cnt++;
                  }
                  else {
                     zero_sum += value;
                  }
               } while((poa_ptr += 5) < poa_ptr_end);
      
               *ptr = minimal_value_map[result];

               // - compute LBP intensity -
               if (one_cnt == a_om_array.used) {
                  *i_ptr = one_sum/one_cnt;
               }
               else {
                  *i_ptr = (one_sum/one_cnt) - (zero_sum/(one_cnt - a_om_array.used));
               }
      
            } while(i_ptr += i_pixel_step,s_ptr += s_pixel_step,(ptr += a_trg.pixel_step) < ptr_w_end);
      
            ptr += line_size - image_ls;
            s_ptr += s_line_size - s_image_ls;
            i_ptr += i_line_size - i_image_ls;
         } while(ptr < ptr_end);
      }
      break;
   case c_image_pixel_format_32U:
      {
         do {
            unsigned char *ptr_w_end = ptr + image_ls;
            do {
               unsigned result = 0;
      
               unsigned one_sum = s_ptr[s_center_offset];
               unsigned zero_sum = 0;
               unsigned one_cnt = 1;

               // - compute binary pattern -
               unsigned *poa_ptr = a_om_array.data;
               unsigned *poa_ptr_end = poa_ptr + a_om_array.used;
      
               do {
                  unsigned char value = (s_ptr[*poa_ptr]*poa_ptr[1] + s_ptr[*poa_ptr + s_pixel_step]*poa_ptr[2] + s_ptr[*poa_ptr + 
                     s_line_size]*poa_ptr[3] + s_ptr[*poa_ptr + s_line_size + s_pixel_step]*poa_ptr[4]) >> (UINT_BIT - CHAR_BIT);
      
                  result <<= 1;
      
                  if (value > s_ptr[s_center_offset]) {
                     result |= 0x01;
                     
                     one_sum += value;
                     one_cnt++;
                  }
                  else {
                     zero_sum += value;
                  }
               } while((poa_ptr += 5) < poa_ptr_end);
      
               // - rotate binary pattern to minimal value -
               unsigned min_result = result;
               unsigned idx = 0;
               do {
                  result = (result & 0x01)?((result >> 1) | first_bit):(result >> 1);
                  min_result = result < min_result?result:min_result;
               } while(++idx < a_pattern_length);
      
               *((unsigned *)ptr) = min_result;

               // - compute LBP intensity -
               if (one_cnt == a_om_array.used) {
                  *i_ptr = one_sum/one_cnt;
               }
               else {
                  *i_ptr = (one_sum/one_cnt) - (zero_sum/(one_cnt - a_om_array.used));
               }

            } while(i_ptr += i_pixel_step,s_ptr += s_pixel_step,(ptr += a_trg.pixel_step) < ptr_w_end);
      
            ptr += line_size - image_ls;
            s_ptr += s_line_size - s_image_ls;
            i_ptr += i_line_size - i_image_ls;
         } while(ptr < ptr_end);
      }
      break;
   default:
      cassert(0);
   }

   return true;
}/*}}}*/

bool lbp_seg_s::seg_lbp_compute_LBP_with_intensity(image_s &a_src,image_s &a_trg,image_s &a_intensity,unsigned a_pattern_length,unsigned a_radius)
{/*{{{*/
   ui_array_s om_array;
   om_array.init();

   bool res;

   res = seg_lbp_compute_offset_and_multiplier_array(a_src,a_pattern_length,a_radius,om_array);
   if (!res) {
      om_array.clear();
      return false;
   }

   res = seg_lbp_compute_LBP_by_offset_and_mutiplier_array_with_intensity(a_src,a_trg,a_intensity,a_pattern_length,a_radius,om_array);
   if (!res) {
      om_array.clear();
      return false;
   }

   om_array.clear();
   return true;
}/*}}}*/

bool lbp_seg_s::compute_lbp_histograms()
{/*{{{*/
   if (lbp_image.pixel_format != c_image_pixel_format_8U) {
      return false;
   }

   width = lbp_image.width - block_size_m1;
   height = lbp_image.height - block_size_m1;
   length = hist_size;

   // - clear seg_data -
   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   // - create seg_data -
   unsigned hist_data_b_size = width*height*hist_bf_b_size;
   seg_data = (float *)cmalloc(hist_data_b_size);

   unsigned pixel_step = lbp_image.pixel_step;
   unsigned line_size = lbp_image.image_data_ptr->line_bytes;
   unsigned image_ls = (lbp_image.width - block_size_m1)*pixel_step;
   unsigned block_ls = block_size*pixel_step;

   unsigned char *ptr = lbp_image.image_data_ptr->data + lbp_image.y_pos*line_size + lbp_image.x_pos*pixel_step;
   unsigned char *ptr_end = ptr + ((lbp_image.height - block_size_m1) - 1)*line_size + (lbp_image.width - block_size_m1)*pixel_step;
   float *lh_ptr = seg_data;

   // - window histogram -
   float w_hist[hist_size];

   do {
      unsigned char *ptr_w_end = ptr + image_ls;
      
      // - clear window histogram -
      memset(w_hist,0,hist_bf_b_size);
      
      // - compute histogram of first pixel of line -
      {
         unsigned char *b_ptr = ptr;
         unsigned char *b_ptr_end = b_ptr + (block_size - 1)*line_size + block_ls;
         do {
            unsigned char *b_ptr_w_end = b_ptr + block_ls;
            do {
               if (*b_ptr != lbp_blank) {
                  w_hist[*b_ptr]++;
               }
            } while((b_ptr += pixel_step) < b_ptr_w_end);

            b_ptr += line_size - block_ls;
         } while(b_ptr < b_ptr_end);
      }

      // - set first pixel histogram -
      memcpy(lh_ptr,w_hist,hist_bf_b_size);

      // - move to second pixel of line -
      lh_ptr += hist_size;
      ptr += pixel_step;

      // - float window over line -
      do {
         unsigned char *b_ptr = ptr;
         unsigned char *b_ptr_end = ptr + block_size*line_size;
         do {
            if (b_ptr[-1] != lbp_blank) {
               w_hist[b_ptr[-1]]--;
            }

            if (b_ptr[block_size - 1] != lbp_blank) {
               w_hist[b_ptr[block_size - 1]]++;
            }

            // - copy histogram -
            memcpy(lh_ptr,w_hist,hist_bf_b_size);

         } while((b_ptr += line_size) < b_ptr_end);
      } while(lh_ptr += hist_size,(ptr += pixel_step) < ptr_w_end);

      ptr += line_size - image_ls;
   } while(ptr < ptr_end);

   return true;
}/*}}}*/

bool lbp_seg_s::create_image_from_lbp_histograms(image_s &a_img)
{/*{{{*/
   if (seg_data == NULL || a_img.pixel_format != c_image_pixel_format_32F || a_img.width < width || a_img.height < height) {
      return false;
   }

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   
   float *n_ptr = seg_data;
   float *n_ptr_end = n_ptr + ((height - 2)*width + width - 1)*hist_size;
   unsigned char *ptr = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;
   do {
      float *n_ptr_w_end = n_ptr + (width - 1)*hist_size;
      do {
         
         /*float *f_ptr = n_ptr;
         float *f_ptr_end = f_ptr + hist_size;

         float r_result = 0.0f;
         float d_result = 0.0f;

         float *fr_ptr = n_ptr + hist_size;
         float *fd_ptr = n_ptr + width*hist_size;
         do {
            register float r_val = *f_ptr - *fr_ptr;
            r_result += r_val*r_val;

            register float d_val = *f_ptr - *fd_ptr;
            d_result += d_val*d_val;
            
         } while(++fd_ptr,++fr_ptr,++f_ptr < f_ptr_end);

         *((float *)ptr) = sqrtf(r_result) + sqrtf(d_result);*/

         float *f_ptr = n_ptr;
         float *f_ptr_end = f_ptr + hist_size;
         do {
            *((float *)ptr) = *f_ptr;
         } while(++f_ptr < f_ptr_end);

      } while(ptr += pixel_step,(n_ptr += hist_size) < n_ptr_w_end);

      n_ptr += hist_size;
      ptr += line_size - ((width - 1)*pixel_step);
   } while(n_ptr < n_ptr_end);

   return true;
}/*}}}*/

void lbp_seg_s::get_feature_parameters_string(string_s &a_fp_str)
{/*{{{*/
   a_fp_str.setf("lbp_blank=%hhu hist_size=%u block_size=%u radius=%u minimal_value_map=",lbp_blank,hist_size,block_size,radius);

   unsigned char *ptr = minimal_value_map;
   unsigned char *ptr_end = ptr + 256;
   do {
      a_fp_str.concf("%hhu,",*ptr);
   } while(++ptr < ptr_end);
}/*}}}*/

bool lbp_seg_s::get_features_MASK(image_s &a_mask,feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_LBP_FEATURES;
   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = 0;
   a_fd.height = 0;

   kernel_info_s ki = {0,0,block_size,block_size};

   unsigned vector_cnt = extract_masked_vectors(seg_data,&a_fd.fv_data,a_mask,ki,length);
   if (vector_cnt == c_idx_not_exist) {
      if (a_fd.fv_data != NULL) {
         cfree(a_fd.fv_data);
         a_fd.fv_data = NULL;
      }
      return false;
   }

   a_fd.fv_cnt = vector_cnt;
   a_fd.fv_length = length;

   return true;
}/*}}}*/

