#!/usr/bin/python

from __base import *
import libxml2
from string import maketrans

TRACE_MEDIAN = SETUP["seg_to_pols"]["TRACE_MEDIAN"]

c_transform_tab = maketrans("(),","   ")
c_polygon_tab = maketrans("mMlLzZ","      ")

polygon_groups = [] # polygon indexes
polygons = []

# -- CLASS transfrom_s ---------------------------------------------------------
# - transformation of topology in SVG file -
class transform_s:
   trans = (0.0,0.0) # tuple (move_x,move_y)
   scale = (0.0,0.0) # tuple (scale_x,scale_y)

   def __init__(self,a_string):
      lst  = a_string.translate(c_transform_tab).split()

      idx = 0
      while idx < len(lst):
         if lst[idx] == "translate":
            self.trans = (int(lst[idx + 1]),int(lst[idx + 2]))
            idx += 3;
         if lst[idx] == "scale":
            self.scale = (float(lst[idx + 1]),float(lst[idx + 2]))
            idx += 3
         else:
            assert 0

# -- CLASS polygon_s -----------------------------------------------------------
# - description of polygon from SVG file -
class polygon_s:
   img_layer_id = 0
   areas_points_lst = []

   # ---------------------------------------------------------------------------
   def __init__(self,a_img_layer_id,a_img_size,a_trans,a_descr):
      """ Process polygon description received from svg file """
      self.img_layer_id = a_img_layer_id
      self.areas_points_lst = []

      # - split polzgon description to polygon elements (border and holes) -
      pol_elem_lst = a_descr.split("z")
      del pol_elem_lst[-1]

      e_idx = 0
      while e_idx < len(pol_elem_lst):
         e_points = []

         lst = pol_elem_lst[e_idx].translate(c_polygon_tab).split()

         # - polygon border (absolute move + translation) -
         if e_idx == 0:
            point = [float(lst[0])*a_trans.scale[0] + a_trans.trans[0],
                     float(lst[1])*a_trans.scale[1] + a_trans.trans[1]]

         # - polygon hole (relative move) -
         else:
            point[0] += float(lst[0])*a_trans.scale[0]
            point[1] += float(lst[1])*a_trans.scale[1]

         e_points.append((point[0]/a_img_size[0],point[1]/a_img_size[1]))

         idx = 2;
         while idx < len(lst):
            point[0] += float(lst[idx])*a_trans.scale[0]
            point[1] += float(lst[idx + 1])*a_trans.scale[1]

            e_points.append((point[0]/a_img_size[0],point[1]/a_img_size[1]))

            idx += 2

         # - test if first and last pointe of sequence are equal, otherwise fix -
         if (e_points[0][0] != e_points[-1][0] or e_points[0][1] != e_points[-1][1]):
            e_points[-1] = e_points[0]

         # - store polygon area points -
         self.areas_points_lst.append(e_points)

         e_idx += 1

   # ---------------------------------------------------------------------------
   def __str__(self):
      return "POLYGON: %s" % str(self.areas_points_lst)

   # ---------------------------------------------------------------------------
   def get_db_repr(self):

      g_str = "POLYGON("
      for a_idx in range(len(self.areas_points_lst)):
         g_str += "%s(" % ("",",")[a_idx != 0]
         area = self.areas_points_lst[a_idx]
         for p_idx in range(len(area)):
            point = area[p_idx]
            g_str += "%s%f %f" %(("",",")[p_idx != 0],point[0],point[1])
         g_str += ')'
      g_str += ')'

      return "DEFAULT, <IMAGE_DB_ID>, <TEXTURE_TYPE:%d:>, ST_PolygonFromText('%s'), '<DESCRIPTION>'" % (self.img_layer_id,g_str)

# ------------------------------------------------------------------------------
def f_process_xml_file(a_file_name,a_img_layer_id):
   """ - process xml file - """

   global polygon_groups
   global polygons

   xml_file = open(a_file_name,"r")
   xml_doc = libxml2.parseDoc(xml_file.read())
   xml_data_base = xml_doc.children

   # - size of processed svg image -
   img_size = [0.0,0.0]

   while xml_data_base is not None:
      if xml_data_base.type == "element" and xml_data_base.name == "svg":
         xml_node_prop = xml_data_base.properties
         while xml_node_prop is not None:
            if xml_node_prop.name == "width":
               
               # - store image width -
               img_size[0] = float(int(xml_node_prop.content.split('pt')[0]))
            elif xml_node_prop.name == "height":

               # - store image height -
               img_size[1] = float(int(xml_node_prop.content.split('pt')[0]))
            xml_node_prop = xml_node_prop.next

         xml_data = xml_data_base.children
         while xml_data is not None:
            if xml_data.type == "element" and xml_data.name == "g":
               polygon_groups.append([])

               xml_node_prop = xml_data.properties
               while xml_node_prop is not None:
                  if xml_node_prop.name == "transform":
                     
                     # - store points transformation -
                     trans = transform_s(xml_node_prop.content)
                  xml_node_prop = xml_node_prop.next

               g_xml_data = xml_data.children
               while g_xml_data is not None:
                  if g_xml_data.type == "element" and g_xml_data.name == "path":
                     xml_node_prop = g_xml_data.properties
                     while xml_node_prop is not None:
                        if xml_node_prop.name == "d":
                           
                           # - process polygon description -
                           polygons.append(polygon_s(a_img_layer_id,img_size,trans,xml_node_prop.content))
                           polygon_groups[-1].append(len(polygons) - 1)

                        xml_node_prop = xml_node_prop.next

                  g_xml_data = g_xml_data.next

            xml_data = xml_data.next

      xml_data_base = xml_data_base.next

   xml_doc.freeDoc()
   xml_file.close();

# - PROGRAM START - ============================================================
if len(sys.argv) != 2:
   err_msg("Expected exactly one file name (grayscale image - result of segmentation and surface-classification)")
   sys.exit(1)

# - split image to slices corresponding to segments -
ret_val = f_execute("rm -f %s/results/*;%s/split %s %s/results/ %s" % (TMP_DIR,BIN_DIR,sys.argv[1],TMP_DIR,TRACE_MEDIAN))
if ret_val != 0:
   err_msg("Cannot split bitmap polygons")
   sys.exit(1)

# - trace segments and interpret resulting polygons -
svg_list_f = f_pipe_execute("cd %s/results;potrace *.bmp -t 10 -a -1 -s;cd ../../;ls %s/results/*.svg" % (TMP_DIR,TMP_DIR))

for line in svg_list_f:
   img_layer_id = int(os.path.splitext(os.path.basename(line))[0].split("_")[1])
   f_process_xml_file(line[:-1],img_layer_id)

svg_list_f.close()

# - print polygons on stdout -
for polygon in polygons:
   print polygon.get_db_repr()

sys.exit(0)

