#!/usr/bin/python

from __base import *
from __pgsql import *

# - PROGRAM START - ============================================================

# - expected arguments <db_video_id> <video_uri> <video_exp_time> <video_exp_loc> <frame_step> -
if len(sys.argv) != 6:
   err_msg("Expected exactly fife arguments <db_video_id> <video_uri> <video_exp_time> <video_exp_loc> <frame_step>")
   sys.exit(1)

ARG_video_id = int(sys.argv[1])
ARG_video_uri = sys.argv[2]

ARG_exp_time = sys.argv[3]
if ARG_exp_time != "NULL":
   ARG_exp_time = "'%s'" % ARG_exp_time

ARG_exp_loc = sys.argv[4]
if ARG_exp_loc != "NULL":
   ARG_exp_loc = "'%s'" % ARG_exp_loc

ARG_frame_step = int(sys.argv[5])

source_video = "%s/%s" % (VIDEOS_DIR,ARG_video_uri)

# - update video state to "in process" state -
f_pgsql_execute("UPDATE videos SET state=%d WHERE id=%d" % (VIDEO_state_in_process,ARG_video_id))
if db_cursor.rowcount != 1:
   f_pgsql_database_error()

f_pgsql_commit();

# - check if given file is video file -
b_video_file = False
vch_res_f = f_pipe_execute("file -b '%s'" % source_video)
for line in vch_res_f:
   for accepted_video_format in ACCEPTED_VIDEO_FORMATS:
      if accepted_video_format in line:
         b_video_file = True
vch_res_f.close()

if not b_video_file:
   err_msg("File '%s' is not proper video file" % source_video)
   f_pgsql_release_database(1)
   sys.exit(1)

# - process and split video file to frames -
video_split_cmd = "%s/video_split %s %s/ %d" % (BIN_DIR,source_video,FRAMES_TO_PROCESS_DIR,ARG_frame_step)
img_list_f = f_pipe_execute(video_split_cmd);

frame_step = int(img_list_f.readline()[:-1].split(" ")[-1])
image_name_lst = []
for image_name in img_list_f:
   image_name_spl = image_name.split(":")
   image_name_lst.append((image_name_spl[1],int(image_name_spl[0]))) # image name, position in miliseconds
img_list_f.close()

# - update video image count -
f_pgsql_execute("UPDATE videos SET frame_step=%d,img_cnt=%d WHERE id=%d" % (frame_step,len(image_name_lst),ARG_video_id))
if db_cursor.rowcount != 1:
   f_pgsql_database_error()

# - create video thumbnail -
if len(image_name_lst) > 0:
   thumb_image_name = image_name_lst[len(image_name_lst)/2][0]
   thumb_cmd = "convert '%s/%s' -resize '%s>' -quality 100%% '%s/%s.%s'" % (FRAMES_TO_PROCESS_DIR,thumb_image_name,THUMBNAIL_SIZE,VIDEOS_THUMBS_DIR,ARG_video_uri,FRAME_EXT)
   f_execute(thumb_cmd)

# - insert images to database -
for image_name in image_name_lst:
   f_pgsql_execute("INSERT INTO images (id,uri,exp_time,exp_loc,state,video_id,video_pos) VALUES (DEFAULT,'%s',%s,%s,%d,%d,%d)" % (image_name[0],ARG_exp_time,ARG_exp_loc,IMAGE_state_uploaded,ARG_video_id,image_name[1]))
   if db_cursor.rowcount != 1:
      f_pgsql_database_error()

f_pgsql_commit();

f_pgsql_release_database(0)
sys.exit(0)

