-- -----------------------------------------------------------------------------
-- Author: ipribyl
-- Date: 2010-10-25 13:04:33 
-- -----------------------------------------------------------------------------

-- -----------------------------------------------------------------------------
-- insert WGS 84 coordinate system (used by GPS) into spatial_ref_sys table,
-- so we can use GPS coordinates
INSERT INTO spatial_ref_sys (srid, auth_name, auth_srid, proj4text, srtext) VALUES (
   94326,
   'epsg',
   4326,
   '+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ',
   'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]'
);
-- -----------------------------------------------------------------------------

DROP TABLE IF EXISTS videos CASCADE;
DROP INDEX IF EXISTS videos_exp_loc_index;
DROP TABLE IF EXISTS images CASCADE;
DROP INDEX IF EXISTS images_exp_loc_index;
DROP TABLE IF EXISTS texture_types CASCADE;
DROP TABLE IF EXISTS object_types CASCADE;
DROP TABLE IF EXISTS objects CASCADE;
DROP INDEX IF EXISTS objects_position_index;
DROP TABLE IF EXISTS segments CASCADE;
DROP INDEX IF EXISTS segments_shape_index;

-- ----------------------------------------------------------------------------

-- - video state -
-- constants (variables) are also defined in engine/__base.py
-- 0 - inserted in DB, not uploaded yet
-- 1 - video file is uploaded
-- 2 - video is already being processed
-- 3 - video is processed
-- 4 - video is in invalid state

CREATE TABLE videos (
   id SERIAL PRIMARY KEY,
   uri VARCHAR(2048) UNIQUE NOT NULL,
   exp_time timestamp NULL DEFAULT NULL, -- date and time of exposure: 'yyyy-mm-dd,hh:mm:ss'
   exp_loc GEOGRAPHY(POINT, 4326) NULL DEFAULT NULL::geography, -- location of exposure in degrees: 'lat, lon'
   frame_step INT NOT NULL,
   img_cnt INT NOT NULL,
   done_img_cnt INT,
   state INT NOT NULL
);

-- - image state - 
-- constants (variables) are also defined in engine/__base.py
-- 0 - inserted in DB, not uploaded yet
-- 1 - image file is uploaded in FRAMES_TO_PROCESS_DIR
-- 2 - image is already being processed
-- 3 - image is processed, file is in FRAMES_DIR
-- 4 - image is in invalid state

CREATE TABLE images (
   id SERIAL PRIMARY KEY,
   uri VARCHAR(2048) UNIQUE NOT NULL,
   exp_time timestamp NULL DEFAULT NULL, -- date and time of exposure: 'yyyy-mm-dd,hh:mm:ss'
   exp_loc GEOGRAPHY(POINT, 4326) NULL DEFAULT NULL::geography, -- location of exposure in degrees: 'lat, lon'
   state INT NOT NULL,
   video_id INT,
   video_pos INT DEFAULT 0 -- position of frame in video (miliseconds)
);

CREATE TABLE texture_types (
   id SERIAL PRIMARY KEY,
   name VARCHAR(64) UNIQUE NOT NULL
);

CREATE TABLE object_types (
   id SERIAL PRIMARY KEY,
   name VARCHAR(64) UNIQUE NOT NULL
);

CREATE TABLE objects (
   id SERIAL PRIMARY KEY,
   type_id SERIAL NOT NULL REFERENCES object_types,
   img_id SERIAL NOT NULL REFERENCES images,
   position GEOMETRY NOT NULL,
   scale_w DOUBLE PRECISION NOT NULL,
   scale_h DOUBLE PRECISION NOT NULL,
   description VARCHAR(1024) NULL DEFAULT NULL
);

CREATE TABLE segments (
   id SERIAL PRIMARY KEY,
   img_id SERIAL NOT NULL REFERENCES images,
   texture_id SERIAL NOT NULL REFERENCES texture_types,
   shape GEOMETRY NOT NULL,
   description VARCHAR(1024) NULL DEFAULT NULL
);

CREATE INDEX objects_position_index ON objects USING GIST (position);
CREATE INDEX segments_shape_index ON segments USING GIST (shape);
CREATE INDEX videos_exp_loc_index ON videos USING GIST (exp_loc);
CREATE INDEX images_exp_loc_index ON images USING GIST (exp_loc);

-- -----------------------------------------------------------------------------

INSERT INTO texture_types VALUES (DEFAULT, 'unknown');
INSERT INTO texture_types VALUES (DEFAULT, 'trees');
INSERT INTO texture_types VALUES (DEFAULT, 'road');
INSERT INTO texture_types VALUES (DEFAULT, 'structure');
INSERT INTO texture_types VALUES (DEFAULT, 'grass');
INSERT INTO texture_types VALUES (DEFAULT, 'lamp');
INSERT INTO texture_types VALUES (DEFAULT, 'sign');
INSERT INTO texture_types VALUES (DEFAULT, 'column');
INSERT INTO texture_types VALUES (DEFAULT, 'pavement');
INSERT INTO texture_types VALUES (DEFAULT, 'wall');
INSERT INTO texture_types VALUES (DEFAULT, 'water');
INSERT INTO texture_types VALUES (DEFAULT, 'roof');
INSERT INTO texture_types VALUES (DEFAULT, 'sky');
INSERT INTO texture_types VALUES (DEFAULT, 'fire');

INSERT INTO object_types VALUES (DEFAULT, 'lamp');
INSERT INTO object_types VALUES (DEFAULT, 'pedestrian');
INSERT INTO object_types VALUES (DEFAULT, 'car_back');
INSERT INTO object_types VALUES (DEFAULT, 'car_front');
INSERT INTO object_types VALUES (DEFAULT, 'car_side');
INSERT INTO object_types VALUES (DEFAULT, 'traffic_sign');
INSERT INTO object_types VALUES (DEFAULT, 'traffic_sign_column');
INSERT INTO object_types VALUES (DEFAULT, 'traffic_light');
INSERT INTO object_types VALUES (DEFAULT, 'traffic_light_column');

-- -----------------------------------------------------------------------------

