#!/bin/bash

function f_server_stop {
   if [ ! -f ./twistd.pid ]
   then
      echo 'WARNING: Server is not running ...'
   else
      echo -n 'Stopping imgproc server ...'
      kill $(cat twistd.pid)
      killall video_daemon.py
      killall image_daemon.py
      echo ' DONE'
   fi
}

function f_server_start {
   echo -n 'Starting imgproc sever ...'
   nohup twistd -n -y ./server/img_proc_s.py 2>&1 2> /dev/null &
   nohup ./image_daemon.py 2>&1 2> /dev/null &
   nohup ./video_daemon.py 2>&1 2> /dev/null &
   echo ' DONE'
}

for arg in $@
do

   case $arg in
   # - start server (if is server already running stop it) -
   start)
      if [ -f ./twistd.pid ]
      then
         echo 'WARNING: Server is already running ...'
         f_server_stop
      fi

      f_server_start
      ;;
   # - stop server -
   stop)
      f_server_stop
      ;;
   restart)
      f_server_stop
      f_server_start
      ;;
   *)
      echo 'expect one argument <action> from set (start, stop, restart)'
      ;;
   esac
done

