#!/usr/bin/python
#coding=utf8

from __base import *
from __pgsql import *

# ------------------------------------------------------------------------------
# dummy functions

#from __pq_getResourceState import *
#from __pq_getSegments import *
#from __pq_getObjects import *
#from __pq_isObjectInSegment import *
#from __pq_isSegmentAdjacent import *

# ------------------------------------------------------------------------------
def f_query_getResourceList(exp_time,exp_loc):
   xml_str = """<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xml SYSTEM "%s/getResourceList.dtd">
<xml>
   <query""" % DTD_WEB_DIR
   
   xml_str += " exp_time_from=\"%s\"" % (exp_time[0] if exp_time != None else "")
   xml_str += " exp_time_to=\"%s\"" % (exp_time[1] if exp_time != None else "")
   xml_str += " exp_loc=\"%s\"" % (gps_decimal2minutes(gps_minutes2decimal(exp_loc[0])) if exp_loc != None else "")
   xml_str += " radius=\"%s\"" % (exp_loc[1] if exp_loc != None else "")
   
   xml_str += """>getResourceList</query>
   <response>
"""
   sql_append_str = ""

   # get parameters exp_time_from, exp_time_to - expected format: yyyy-mm-dd,hh:mm:ss
   if exp_time != None:
      sql_append_str += " AND exp_time >= '%s' AND exp_time <= '%s'" % (exp_time[0], exp_time[1])
      
   # get parameters exp_loc_center, radius - expected formats: "[N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss", float
   if exp_loc != None:
      exp_loc_center = DBin_geo_point(exp_loc[0])
      radius = exp_loc[1]
      sql_append_str += " AND ST_Distance(exp_loc, ST_GeographyFromText('SRID=4326;%s')) <= %s" % (exp_loc_center, radius)

   f_pgsql_execute("SELECT uri, state, exp_time, ST_AsText(exp_loc) FROM images WHERE video_id=0 %s ORDER BY id" % sql_append_str)
   for result in db_cursor.fetchall():
      xml_str += "      <resource"
      xml_str += " uri=\"%s\"" % result[0]
      xml_str += " type=\"image\""
      xml_str += " state=\"%s\"" % IMAGE_state_strings[int(result[1])]
      xml_str += " exp_time=\"%s\"" % DBout_datetime(result[2])
      xml_str += " exp_loc=\"%s\"" % DBout_geo_point(result[3])
      xml_str += ">%s</resource>\n" % result[0]

   f_pgsql_execute("SELECT uri, state, exp_time, ST_AsText(exp_loc) FROM videos WHERE 1=1 %s ORDER BY id" % sql_append_str)
   for result in db_cursor.fetchall():
      xml_str += "      <resource"
      xml_str += " uri=\"%s\"" % result[0]
      xml_str += " type=\"video\""
      xml_str += " state=\"%s\"" % VIDEO_state_strings[int(result[1])]
      xml_str += " exp_time=\"%s\"" % DBout_datetime(result[2])
      xml_str += " exp_loc=\"%s\"" % DBout_geo_point(result[3])
      xml_str += ">%s</resource>\n" % result[0]

   xml_str += """   </response>
</xml>
"""

   return xml_str

# ------------------------------------------------------------------------------
def f_query_getResourceState(resource_uri):

   xml_str = """<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xml SYSTEM "%s/getResourceState.dtd">
<xml>
   <query""" % DTD_WEB_DIR
   
   xml_str += " resource_uri=\"%s\"" % resource_uri
   
   xml_str += """>getResourceState</query>
   <response>
"""

   f_pgsql_execute("SELECT id, uri, state, exp_time, ST_AsText(exp_loc) FROM videos WHERE uri='%s'" % resource_uri)
   if db_cursor.rowcount != 0:
      # video
      result = db_cursor.fetchone()
      video_id = int(result[0])
      video_uri = result[1]
      video_state = int(result[2])
      video_exp_time = DBout_datetime(result[3])
      video_exp_loc = DBout_geo_point(result[4])
      
      xml_str += "<resource"
      xml_str += " uri=\"%s\"" % video_uri
      xml_str += " state=\"%s\"" % VIDEO_state_strings[video_state]
      xml_str += " exp_time=\"%s\"" % video_exp_time
      xml_str += " exp_loc=\"%s\"" % video_exp_loc
      xml_str += " />"

      f_pgsql_execute("SELECT uri, video_pos FROM images WHERE video_id=%d ORDER BY id" % video_id)
      xml_str += "      <frames count=\"%d\">\n" % db_cursor.rowcount
      if db_cursor.rowcount != 0:
         for result in db_cursor.fetchall():
            xml_str += "         <frame uri=\"%s\" video_pos=\"%d\">%s</frame>\n" % (result[0],int(result[1]),result[0])
      xml_str += "      </frames>\n"

   else:
      f_pgsql_execute("SELECT id, uri, state, exp_time, ST_AsText(exp_loc), video_id, video_pos FROM images WHERE uri='%s'" % resource_uri)
      if db_cursor.rowcount != 0:
         # image
         result = db_cursor.fetchone()
         image_id = int(result[0])
         image_uri = result[1]
         image_state = int(result[2])
         image_exp_time = DBout_datetime(result[3])
         image_exp_loc = DBout_geo_point(result[4])
         image_video_id = int(result[5])
         image_video_pos = int(result[6])

         xml_str += "      <resource"
         xml_str += " uri=\"%s\"" % image_uri
         xml_str += " state=\"%s\"" % IMAGE_state_strings[image_state]

         if image_video_id != 0:
            f_pgsql_execute("SELECT uri FROM videos WHERE id=%d" % image_video_id)
            assert db_cursor.rowcount != 0

            image_video_uri = db_cursor.fetchone()[0]
            xml_str += " video_uri=\"%s\"" % image_video_uri
            xml_str += " video_pos=\"%d\"" % image_video_pos

         xml_str += " exp_time=\"%s\"" % image_exp_time
         xml_str += " exp_loc=\"%s\"" % image_exp_loc
         xml_str += " />\n"
         
         f_pgsql_execute("SELECT id FROM segments WHERE img_id=%d" % image_id)
         xml_str += "      <item name=\"segments\">%d</item>\n" % db_cursor.rowcount

         f_pgsql_execute("SELECT id FROM objects WHERE img_id=%d" % image_id)
         xml_str += "      <item name=\"objects\">%d</item>\n" % db_cursor.rowcount

      else:
         # no resource
         xml_str += "      Resource does not exist\n"

   xml_str += """   </response>
</xml>
"""

   return xml_str

# ------------------------------------------------------------------------------
def f_query_getSegments(resource_uri):

   xml_str = """<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xml SYSTEM "%s/getSegments.dtd">
<xml>
   <query""" % DTD_WEB_DIR
   
   xml_str += " resource_uri=\"%s\"" % resource_uri
   
   xml_str += """>getSegments</query>
   <response>
"""

   f_pgsql_execute("SELECT id, uri, state, exp_time, ST_AsText(exp_loc) FROM videos WHERE uri='%s'" % resource_uri)
   if db_cursor.rowcount != 0:
      # video: average from image results
      result = db_cursor.fetchone()
      video_id = int(result[0])
      video_uri = result[1]
      video_state = int(result[2])
      video_exp_time = DBout_datetime(result[3])
      video_exp_loc = DBout_geo_point(result[4])
      
      xml_str += "<resource"
      xml_str += " uri=\"%s\"" % video_uri
      xml_str += " state=\"%s\"" % VIDEO_state_strings[video_state]
      xml_str += " exp_time=\"%s\"" % video_exp_time
      xml_str += " exp_loc=\"%s\"" % video_exp_loc
      xml_str += " />"
      
      f_pgsql_execute("SELECT sss.name, AVG(sss.area) \
            FROM (\
               SELECT ss.name, SUM(ST_Area(ss.shape)) AS area \
               FROM (\
                  SELECT * \
                  FROM segments AS s \
                  LEFT JOIN texture_types AS tt ON tt.id=s.texture_id \
                  LEFT JOIN images AS i ON i.id=s.img_id \
                  LEFT JOIN videos AS v ON v.id=i.video_id \
                  WHERE v.id='%s'\
               ) AS ss \
               GROUP BY ss.img_id, ss.name \
            ) AS sss GROUP BY sss.name" % video_id)
         
      for result in db_cursor.fetchall():
         xml_str += "      <item name=\"%s\">%f</item>\n" % (result[0],float(result[1]))
      
   else:
      f_pgsql_execute("SELECT id, uri, state, exp_time, ST_AsText(exp_loc) FROM images WHERE uri='%s'" % resource_uri)
      if db_cursor.rowcount != 0:
         # image
         result = db_cursor.fetchone()
         image_id = int(result[0])
         image_uri = result[1]
         image_state = int(result[2])
         image_exp_time = DBout_datetime(result[3])
         image_exp_loc = DBout_geo_point(result[4])

         xml_str += "<resource"
         xml_str += " uri=\"%s\"" % image_uri
         xml_str += " state=\"%s\"" % IMAGE_state_strings[image_state]
         xml_str += " exp_time=\"%s\"" % image_exp_time
         xml_str += " exp_loc=\"%s\"" % image_exp_loc
         xml_str += " />"
   
         f_pgsql_execute("SELECT ss.name, SUM(ST_Area(ss.shape)) AS area \
            FROM (\
               SELECT * \
               FROM segments AS s \
               LEFT JOIN texture_types AS tt ON tt.id=s.texture_id \
               WHERE img_id='%s'\
            ) AS ss \
            GROUP BY ss.name" % image_id)
         
         for result in db_cursor.fetchall():
            xml_str += "      <item name=\"%s\">%f</item>\n" % (result[0],float(result[1]))
   
      else:
         # no resource
         xml_str += "      Resource does not exist\n"

   xml_str += """   </response>
</xml>
"""

   return xml_str
   
# ------------------------------------------------------------------------------
def f_query_getObjects(resource_uri):
   
   # build begin of xml
   xml_str = """<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xml SYSTEM "%s/getObjects.dtd">
<xml>
   <query""" % DTD_WEB_DIR
   
   xml_str += " resource_uri=\"%s\"" % resource_uri
   
   xml_str += """>getObjects</query>
  <response>
"""

   f_pgsql_execute("SELECT id, uri, state, exp_time, ST_AsText(exp_loc) FROM videos WHERE uri='%s'" % resource_uri)
   if db_cursor.rowcount != 0:
      # video: maximum from image results
      result = db_cursor.fetchone()
      video_id = int(result[0])
      video_uri = result[1]
      video_state = int(result[2])
      video_exp_time = DBout_datetime(result[3])
      video_exp_loc = DBout_geo_point(result[4])
      
      xml_str += "<resource"
      xml_str += " uri=\"%s\"" % video_uri
      xml_str += " state=\"%s\"" % VIDEO_state_strings[video_state]
      xml_str += " exp_time=\"%s\"" % video_exp_time
      xml_str += " exp_loc=\"%s\"" % video_exp_loc
      xml_str += " />"
      
      f_pgsql_execute("SELECT fr.object_type, MAX(fr.count) as count \
            FROM ( \
               SELECT ot.name AS object_type, COUNT(o.*) AS count \
               FROM objects AS o \
               LEFT JOIN object_types AS ot ON ot.id=o.type_id \
               LEFT JOIN images AS i ON i.id=o.img_id \
               LEFT JOIN videos AS v ON v.id=i.video_id \
               WHERE v.id='%s' \
               GROUP BY ot.name, i.id) AS fr \
            GROUP BY fr.object_type" % video_id)
         
      # build list of objects
      for objectType in db_cursor.fetchall():
         objectTypeName = objectType[0]
         objectTypeCount = objectType[1]
         xml_str += "    <item name=\"" + objectTypeName + "\">" + str(objectTypeCount) + "</item>\n"
      
   else:
      f_pgsql_execute("SELECT id, uri, state, exp_time, ST_AsText(exp_loc) FROM images WHERE uri='%s'" % resource_uri)
      if db_cursor.rowcount != 0:
         # image
         result = db_cursor.fetchone()
         image_id = int(result[0])
         image_uri = result[1]
         image_state = int(result[2])
         image_exp_time = DBout_datetime(result[3])
         image_exp_loc = DBout_geo_point(result[4])

         xml_str += "<resource"
         xml_str += " uri=\"%s\"" % image_uri
         xml_str += " state=\"%s\"" % IMAGE_state_strings[image_state]
         xml_str += " exp_time=\"%s\"" % image_exp_time
         xml_str += " exp_loc=\"%s\"" % image_exp_loc
         xml_str += " />"
         
         # query for object counts
         f_pgsql_execute("SELECT ot.name AS object_type, COUNT(o.*) AS count \
            FROM objects AS o \
            LEFT JOIN object_types AS ot ON ot.id=o.type_id \
            LEFT JOIN images AS i on i.id=o.img_id \
            WHERE i.id='%s' \
            GROUP BY ot.name" % image_id)
   
         # build list of objects
         for objectType in db_cursor.fetchall():
            objectTypeName = objectType[0]
            objectTypeCount = objectType[1]
            xml_str += "    <item name=\"" + objectTypeName + "\">" + str(objectTypeCount) + "</item>\n"
            
      else:
         # no resource
         xml_str += "      Resource does not exist\n"
   
   # build end of xml
   xml_str += """   </response>
</xml>
"""
   
   return xml_str
   
# ------------------------------------------------------------------------------
def f_query_isObjectInSegment(resource_uri, segment_type, object_type, exp_time, exp_loc):

   response_str = """   <response>
      <resource uri="%s" exp_time="%s" exp_loc="%s" />
      <result segment_type="%s" object_type="%s">%d</result>
   </response>
"""

   # - build begin of xml -
   xml_str  = """<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xml SYSTEM "%s/isObjectInSegment.dtd">
<xml>
   <query resource_uri="%s" segment_type="%s" object_type="%s" exp_time_from="%s" exp_time_to="%s" exp_loc="%s" radius="%s">isObjectInSegment</query>
""" % (DTD_WEB_DIR,
(resource_uri if resource_uri != None else ""),
segment_type,
object_type,
(exp_time[0] if exp_time != None else ""),
(exp_time[1] if exp_time != None else ""),
(gps_decimal2minutes(gps_minutes2decimal(exp_loc[0])) if exp_loc != None else ""),
(exp_loc[1] if exp_loc != None else ""))

   process_videos = True
   process_images = True
   sql_append_str = ""

   # - test if required resource exist as video -
   if resource_uri != None:
      f_pgsql_execute("SELECT id,exp_time,ST_AsText(exp_loc) FROM videos WHERE uri='%s'" % resource_uri)
      if db_cursor.rowcount != 0:
         result = db_cursor.fetchone()
         ru_exp_time = result[1]
         ru_exp_loc = result[2]
         process_images = False
         sql_append_str = "AND v.uri = '%s'" % resource_uri
      else:
         process_videos = False
      
   # get parameters exp_time_from, exp_time_to - expected format: yyyy-mm-dd,hh:mm:ss
   if exp_time != None:
      sql_append_str += " AND v.exp_time >= '%s' AND v.exp_time <= '%s'" % (exp_time[0], exp_time[1])

   # get parameters exp_loc_center, radius - expected formats: "[N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss", float
   if exp_loc != None:
      exp_loc_center = DBin_geo_point(exp_loc[0])
      radius = exp_loc[1]
      sql_append_str += " AND ST_Distance(v.exp_loc, ST_GeographyFromText('SRID=4326;%s')) <= %s" % (exp_loc_center, radius)

   # - PROCESS VIDEOS -
   if process_videos:
      f_pgsql_execute("""
SELECT bool_or(
   ST_Distance(
      ST_Polygon(ST_GeomFromText('LINESTRING(' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ')'), -1), 
      s.shape 
   ) < 0.1 
), v.uri, v.exp_time, ST_AsText(v.exp_loc)
FROM images AS i 
LEFT JOIN videos AS v ON v.id=i.video_id 
LEFT JOIN objects AS o ON o.img_id=i.id 
LEFT JOIN segments AS s ON s.img_id=o.img_id 
LEFT JOIN object_types AS ot ON ot.id=o.type_id 
LEFT JOIN texture_types AS tt ON tt.id=s.texture_id 
WHERE ot.name='%s' AND tt.name='%s' %s GROUP BY v.uri, v.exp_time, v.exp_loc
""" % (object_type,segment_type,sql_append_str))

      found = 0
      if db_cursor.rowcount != 0:
         results = db_cursor.fetchall()
         for result in results:
            # - "result[1] != None" ignore images linked to empty video -
            if result[1] != None and result[0] == True:
               found = 1
            
               # - append found results to output xml -
               xml_str += response_str % (result[1],DBout_datetime(result[2]),DBout_geo_point(result[3]),segment_type,object_type,1)

      # - no result for given resource_uri -
      if resource_uri != None and found == 0:
         xml_str += response_str % (resource_uri,DBout_datetime(ru_exp_time),DBout_geo_point(ru_exp_loc),segment_type,object_type,0)
   
   # - PROCESS IMAGES -
   if process_images:
      sql_append_str = ""

      # - test if required resource exist as image -
      if resource_uri != None:
         f_pgsql_execute("SELECT id,exp_time,ST_AsText(exp_loc) FROM images WHERE uri='%s'" % resource_uri)
         if db_cursor.rowcount == 0:
            xml_str += """   <response>
      <resource uri="%s" />
      <result segment_type="%s" object_type="%s">Resource does not exist</result>
   </response>
</xml>
""" % (resource_uri,segment_type,object_type)
            return xml_str

         else:
            result = db_cursor.fetchone()
            ru_exp_time = result[1]
            ru_exp_loc = result[2]
            sql_append_str = "AND i.uri='%s'" % resource_uri
      
      # get parameters exp_time_from, exp_time_to - expected format: yyyy-mm-dd,hh:mm:ss
      if exp_time != None:
         sql_append_str += " AND i.exp_time >= '%s' AND i.exp_time <= '%s'" % (exp_time[0], exp_time[1])

      # get parameters exp_loc_center, radius - expected formats: "[N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss", float
      if exp_loc != None:
         exp_loc_center = DBin_geo_point(exp_loc[0])
         radius = exp_loc[1]
         sql_append_str += " AND ST_Distance(i.exp_loc, ST_GeographyFromText('SRID=4326;%s')) <= %s" % (exp_loc_center, radius)

      f_pgsql_execute("""
SELECT bool_or(
   ST_Distance(
      ST_Polygon(ST_GeomFromText('LINESTRING(' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ')'), -1), 
      s.shape 
   ) < 0.1 
), i.uri, i.exp_time, ST_AsText(i.exp_loc)
FROM images AS i 
LEFT JOIN objects AS o ON o.img_id=i.id 
LEFT JOIN segments AS s ON s.img_id=o.img_id 
LEFT JOIN object_types AS ot ON ot.id=o.type_id 
LEFT JOIN texture_types AS tt ON tt.id=s.texture_id 
WHERE ot.name='%s' AND tt.name='%s' %s GROUP BY i.uri, i.exp_time, i.exp_loc
""" % (object_type,segment_type,sql_append_str))
     
      found = 0
      if db_cursor.rowcount != 0:
         results = db_cursor.fetchall()
         for result in results:
            if result[0] == True:
               found = 1

               # - append found results to output xml -
               xml_str += response_str % (result[1],DBout_datetime(result[2]),DBout_geo_point(result[3]),segment_type,object_type,1)

      # - no result for given resource uri -
      if resource_uri != None and found == 0:
         xml_str += response_str % (resource_uri,DBout_datetime(ru_exp_time),DBout_geo_point(ru_exp_loc),segment_type,object_type,0)

   # - build end of xml -
   xml_str += """</xml>
"""
   
   return xml_str

# ------------------------------------------------------------------------------
def f_query_isSegmentAdjacent(resource_uri,segment_type1,segment_type2,exp_time,exp_loc):

   response_str = """   <response>
      <resource uri="%s" exp_time="%s" exp_loc="%s" />
      <result segment_type1="%s" segment_type2="%s">%d</result>
   </response>
"""

   # - build begin of xml -
   xml_str  = """<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xml SYSTEM "%s/isSegmentAdjacent.dtd">
<xml>
   <query resource_uri="%s" segment_type1="%s" segment_type2="%s" exp_time_from="%s" exp_time_to="%s" exp_loc="%s" radius="%s">isSegmentAdjacent</query>
""" % (DTD_WEB_DIR,
(resource_uri if resource_uri != None else ""),
segment_type1,
segment_type2,
(exp_time[0] if exp_time != None else ""),
(exp_time[1] if exp_time != None else ""),
(gps_decimal2minutes(gps_minutes2decimal(exp_loc[0])) if exp_loc != None else ""),
(exp_loc[1] if exp_loc != None else ""))

   process_videos = True
   process_images = True
   sql_append_str = ""

   # - test if required resource exist as video -
   if resource_uri != None:
      f_pgsql_execute("SELECT id,exp_time,ST_AsText(exp_loc) FROM videos WHERE uri='%s'" % resource_uri)
      if db_cursor.rowcount != 0:
         result = db_cursor.fetchone();
         ru_exp_time = result[1]
         ru_exp_loc = result[2]
         process_images = False
         sql_append_str = "AND v.uri = '%s'" % resource_uri
      else:
         process_videos = False

   # get parameters exp_time_from, exp_time_to - expected format: yyyy-mm-dd,hh:mm:ss
   if exp_time != None:
      sql_append_str += " AND v.exp_time >= '%s' AND v.exp_time <= '%s'" % (exp_time[0], exp_time[1])

   # get parameters exp_loc_center, radius - expected formats: "[N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss", float
   if exp_loc != None:
      exp_loc_center = DBin_geo_point(exp_loc[0])
      radius = exp_loc[1]
      sql_append_str += " AND ST_Distance(v.exp_loc, ST_GeographyFromText('SRID=4326;%s')) <= %s" % (exp_loc_center, radius)
   
   # - PROCESS VIDEOS -
   if process_videos:
      f_pgsql_execute("""
SELECT bool_or(ST_Distance(s1.shape, s2.shape) < 0.001), v.uri, v.exp_time, ST_AsText(v.exp_loc)
FROM images AS i 
LEFT JOIN videos AS v ON v.id=i.video_id 
LEFT JOIN segments AS s1 ON s1.img_id=i.id 
LEFT JOIN segments AS s2 ON s2.img_id=i.id 
LEFT JOIN texture_types AS tt1 ON tt1.id=s1.texture_id 
LEFT JOIN texture_types AS tt2 ON tt2.id=s2.texture_id 
WHERE s1.id!=s2.id AND tt1.name='%s' AND tt2.name='%s' %s GROUP BY v.uri, v.exp_time, v.exp_loc
""" % (segment_type1,segment_type2,sql_append_str))
         
      adjacent = 0
      if db_cursor.rowcount != 0:
         results = db_cursor.fetchall()
         for result in results:
            if result[1] != None and result[0] == True:
               adjacent = 1

               # - append found results to output xml -
               xml_str += response_str % (result[1],DBout_datetime(result[2]),DBout_geo_point(result[3]),segment_type1,segment_type2,1)

      # - not adjacent segments for given resource uri -
      if resource_uri != None and adjacent == 0:
         xml_str += response_str % (resource_uri,DBout_datetime(ru_exp_time),DBout_geo_point(ru_exp_loc),segment_type1,segment_type2,0)

   # - PROCESS IMAGES -
   if process_images:
      sql_append_str = ""

      # - test if required resource exist as image -
      if resource_uri != None:
         f_pgsql_execute("SELECT id,exp_time,ST_AsText(exp_loc) FROM images WHERE uri='%s'" % resource_uri)
         if db_cursor.rowcount == 0:
            xml_str += """   <response>
      <resource uri="%s" />
      <result segment_type1="%s" segment_type2="%s">Resource does not exist</result>
   </response>
</xml>
""" % (resource_uri,segment_type1,segment_type2)
            return xml_str

         else:
            result = db_cursor.fetchone()
            ru_exp_time = result[1]
            ru_exp_loc = result[2]
            sql_append_str = "AND i.uri='%s'" % resource_uri
      
      # get parameters exp_time_from, exp_time_to - expected format: yyyy-mm-dd,hh:mm:ss
      if exp_time != None:
         sql_append_str += " AND i.exp_time >= '%s' AND i.exp_time <= '%s'" % (exp_time[0], exp_time[1])

      # get parameters exp_loc_center, radius - expected formats: "[N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss", float
      if exp_loc != None:
         exp_loc_center = DBin_geo_point(exp_loc[0])
         radius = exp_loc[1]
         sql_append_str += " AND ST_Distance(i.exp_loc, ST_GeographyFromText('SRID=4326;%s')) <= %s" % (exp_loc_center, radius)
      
      f_pgsql_execute("""
SELECT bool_or(ST_Distance(s1.shape, s2.shape) < 0.001), i.uri, i.exp_time, ST_AsText(i.exp_loc)
FROM images AS i 
LEFT JOIN segments AS s1 ON s1.img_id=i.id 
LEFT JOIN segments AS s2 ON s2.img_id=i.id 
LEFT JOIN texture_types AS tt1 ON tt1.id=s1.texture_id 
LEFT JOIN texture_types AS tt2 ON tt2.id=s2.texture_id 
WHERE s1.id!=s2.id AND tt1.name='%s' AND tt2.name='%s' %s GROUP BY i.uri, i.exp_time, i.exp_loc
""" % (segment_type1,segment_type2,sql_append_str))

      adjacent = 0
      if db_cursor.rowcount != 0:
         results = db_cursor.fetchall()
         for result in results:
            if result[0] == True:
               adjacent = 1

               # - append found results to output xml -
               xml_str += response_str % (result[1],DBout_datetime(result[2]),DBout_geo_point(result[3]),segment_type1,segment_type2,1)

      # - not adjacent found for given uri -
      if resource_uri != None and adjacent == 0:
         xml_str += response_str % (resource_uri,DBout_datetime(ru_exp_time),DBout_geo_point(ru_exp_loc),segment_type1,segment_type2,0)

   # - build end of xml -
   xml_str += """</xml>
"""
   
   return xml_str

# ------------------------------------------------------------------------------

def f_get_video_info_str(a_video_id,a_video_pos):
   if a_video_id != 0:
      f_pgsql_execute("SELECT uri FROM videos WHERE id = %d" % a_video_id)
      if db_cursor.rowcount == 0:
         return ""

      return "video_uri=\"%s\" video_pos=\"%d\"" % (db_cursor.fetchone()[0],a_video_pos)
   else:
      return ""

def f_query_tag(resource_uri,tag,exp_time,exp_loc):
   
   response_str = """   <response>
      <resource uri="%s" type="%s" %s exp_time="%s" exp_loc="%s" />
      <result tag="%s">%d</result>
   </response>
"""

   # - build begin of xml -
   xml_str = """<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xml SYSTEM "%s/tag.dtd">
<xml>
   <query resource_uri="%s" tag="%s" exp_time_from="%s" exp_time_to="%s" exp_loc="%s" radius="%s">tag</query>
""" % (DTD_WEB_DIR,
(resource_uri if resource_uri != None else ""),
tag,
(exp_time[0] if exp_time != None else ""),
(exp_time[1] if exp_time != None else ""),
(gps_decimal2minutes(gps_minutes2decimal(exp_loc[0])) if exp_loc != None else ""),
(exp_loc[1] if exp_loc != None else ""))

   process_videos = True
   process_images = True
   sql_command = ""
   sql_append_str = ""

   # - process tag type -
   if tag == "car_in_fire":
      # - tag: car_in_fire -
      sql_command = """
SELECT bool_or(
   ST_Distance(
      ST_Polygon(ST_GeomFromText('LINESTRING(' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ')'), -1), 
      s.shape 
   ) < 0.1 
), %s
FROM images AS i 
%s
LEFT JOIN objects AS o ON o.img_id=i.id 
LEFT JOIN segments AS s ON s.img_id=o.img_id 
LEFT JOIN object_types AS ot ON ot.id=o.type_id 
LEFT JOIN texture_types AS tt ON tt.id=s.texture_id 
WHERE ((ot.name='car_back' OR ot.name='car_side') AND tt.name='fire') %s GROUP BY %s
"""

   elif tag == "car_in_water":
      # - tag: car_in_water -
      sql_command = """
SELECT bool_or(
   ST_Distance(
      ST_Polygon(ST_GeomFromText('LINESTRING(' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ')'), -1), 
      s.shape 
   ) < 0.1 
), %s
FROM images AS i 
%s
LEFT JOIN objects AS o ON o.img_id=i.id 
LEFT JOIN segments AS s ON s.img_id=o.img_id 
LEFT JOIN object_types AS ot ON ot.id=o.type_id 
LEFT JOIN texture_types AS tt ON tt.id=s.texture_id 
WHERE ((ot.name='car_back' OR ot.name='car_side') AND tt.name='water') %s GROUP BY %s
"""

   elif tag == "man_in_water":
      # - tag: man_in_water - TODO: remove frames containing fire
      sql_command = """
SELECT bool_or(
   ST_Distance(
      ST_Polygon(ST_GeomFromText('LINESTRING(' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ')'), -1), 
      s.shape 
   ) < 0.1 
), %s
FROM images AS i 
%s
LEFT JOIN objects AS o ON o.img_id=i.id 
LEFT JOIN segments AS s ON s.img_id=o.img_id 
LEFT JOIN object_types AS ot ON ot.id=o.type_id 
LEFT JOIN texture_types AS tt ON tt.id=s.texture_id 
WHERE (ot.name='pedestrian' AND tt.name='water') %s GROUP BY %s
"""

   elif tag == "fire":
      # - tag: fire
      sql_command = """
SELECT 1, %s 
FROM images AS i 
%s
LEFT JOIN segments AS s ON s.img_id=i.id 
LEFT JOIN texture_types AS tt ON tt.id=s.texture_id 
WHERE tt.name='fire' %s GROUP BY %s
"""

   elif tag == "flood":
      # - tag: flood - TODO: remove frames containing fire
      sql_command = """
SELECT bool_or(
   ST_Distance(
      ST_Polygon(ST_GeomFromText('LINESTRING(' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) || ', ' 
         || ST_X(o.position) + o.scale_w || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) + o.scale_h || ', ' 
         || ST_X(o.position) || ' ' || ST_Y(o.position) || ')'), -1), 
      s.shape 
   ) < 0.1 
), %s
FROM images AS i 
%s
LEFT JOIN objects AS o ON o.img_id=i.id 
LEFT JOIN segments AS s ON s.img_id=o.img_id 
LEFT JOIN object_types AS ot ON ot.id=o.type_id 
LEFT JOIN texture_types AS tt ON tt.id=s.texture_id 
WHERE ((ot.name='car_side' OR ot.name='car_back' OR ot.name='traffic_sign' OR ot.name='pedestrian') AND tt.name='water') %s GROUP BY %s
"""

   else:
      xml_str += """   <response>
      <resource uri="%s" />
      <result tag="%s">Tag is not defined</result>
   </response>
</xml>""" % (resource_uri if resource_uri != None else "",tag)
      return xml_str

   # - test if required resource exist as video -
   if resource_uri != None:
      f_pgsql_execute("SELECT id, exp_time, ST_AsText(exp_loc) FROM videos WHERE uri='%s'" % resource_uri)
      if db_cursor.rowcount != 0:
         result = db_cursor.fetchone()
         ru_exp_time = result[1]
         ru_exp_loc = result[2]
         process_images = False
         sql_append_str = "AND v.uri = '%s'" % resource_uri
      else:
         process_videos = False

   # get parameters exp_time_from, exp_time_to - expected format: yyyy-mm-dd,hh:mm:ss
   if exp_time != None:
      sql_append_str += " AND v.exp_time >= '%s' AND v.exp_time <= '%s'" % (exp_time[0], exp_time[1])

   # get parameters exp_loc_center, radius - expected formats: "[N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss", float
   if exp_loc != None:
      exp_loc_center = DBin_geo_point(exp_loc[0])
      radius = exp_loc[1]
      sql_append_str += " AND ST_Distance(v.exp_loc, ST_GeographyFromText('SRID=4326;%s')) <= %s" % (exp_loc_center, radius)

   # - PROCESS VIDEOS -
   if process_videos:
      f_pgsql_execute(sql_command % ("v.uri, v.exp_time, ST_AsText(v.exp_loc)","LEFT JOIN videos AS v ON v.id=i.video_id",sql_append_str,"v.uri, v.exp_time, v.exp_loc"))

      fulfilled = 0
      if db_cursor.rowcount != 0:
         results = db_cursor.fetchall()
         for result in results:
            if result[1] != None and result[0] == True:
               fulfilled = 1

               # - append fulfilled results to output xml -
               xml_str += response_str % (result[1],"video","",DBout_datetime(result[2]),DBout_geo_point(result[3]),tag,1)

      # - no result for given resource uri -
      if resource_uri != None and fulfilled == 0:
         xml_str += response_str % (resource_uri,"video","",DBout_datetime(ru_exp_time),DBout_geo_point(ru_exp_loc),tag,0)

   # - PROCESS IMAGES -
   if process_images:
      sql_append_str = ""
      
      # - test if required resource exist as image -
      if resource_uri != None:
         f_pgsql_execute("SELECT id, exp_time, ST_AsText(exp_loc), video_id, video_pos FROM images WHERE uri='%s'" % resource_uri)
         if db_cursor.rowcount == 0:
            xml_str += """   <response>
      <resource uri="%s" />
      <result tag="%s">Resource does not exist</result>
   </response>
</xml>
""" % (resource_uri,tag)
            return xml_str

         else:
            result = db_cursor.fetchone()
            ru_exp_time = result[1]
            ru_exp_loc = result[2]
            ru_video_id = int(result[3])
            ru_video_pos = int(result[4])
            sql_append_str = "AND i.uri='%s'" % resource_uri

      # get parameters exp_time_from, exp_time_to - expected format: yyyy-mm-dd,hh:mm:ss
      if exp_time != None:
         sql_append_str += " AND i.exp_time >= '%s' AND i.exp_time <= '%s'" % (exp_time[0], exp_time[1])

      # get parameters exp_loc_center, radius - expected formats: "[N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss", float
      if exp_loc != None:
         exp_loc_center = DBin_geo_point(exp_loc[0])
         radius = exp_loc[1]
         sql_append_str += " AND ST_Distance(i.exp_loc, ST_GeographyFromText('SRID=4326;%s')) <= %s" % (exp_loc_center, radius)

      f_pgsql_execute(sql_command % ("i.uri, i.exp_time, ST_AsText(i.exp_loc), i.video_id, i.video_pos","",sql_append_str,"i.uri, i.exp_time, i.exp_loc, i.video_id, i.video_pos"))

      fulfilled = 0
      if db_cursor.rowcount != 0:
         results = db_cursor.fetchall()
         for result in results:
            if result[0] == True:
               fulfilled = 1

               video_id = int(result[4])
               video_info_str = f_get_video_info_str(video_id,int(result[5]))

               # - append fulfilled results to output xml -
               xml_str += response_str % (result[1],"video_frame" if video_id != 0 else "image",video_info_str,DBout_datetime(result[2]),DBout_geo_point(result[3]),tag,1)

      # - no result for given resource uri -
      if resource_uri != None and fulfilled == 0:

         video_info_str = f_get_video_info_str(ru_video_id,ru_video_pos)
         xml_str += response_str % (resource_uri,"video_frame" if ru_video_id != 0 else "image",video_info_str,DBout_datetime(ru_exp_time),DBout_geo_point(ru_exp_loc),tag,0)

   # - build end of xml -
   xml_str += """</xml>
"""

   return xml_str

