
from __base import *
import psycopg2

# - cursor methods -
# db_cursor.execute("SELECT * FROM objects") - execute SQL query
# db_cursor.rowcount - count of rows
# db_cursor.fetchone() - fetch one result
# db_cursor.fetchall() - fetch all results

# - connect to database -
db_conn = psycopg2.connect(
   "host=localhost dbname=%s user=%s password=%s" % (DATABASE_NAME,DATABASE_USER,DATABASE_PASSWD)
)

db_cursor = db_conn.cursor()
last_sql_cmd = ""

# ------------------------------------------------------------------------------
def f_pgsql_execute(a_sql_cmd):
   """ - execute postgre command - """
   global last_sql_cmd
   log_msg("PgSQL Execute: %s" % a_sql_cmd)
   last_sql_cmd = a_sql_cmd
   return db_cursor.execute(a_sql_cmd)

# ------------------------------------------------------------------------------
def f_pgsql_get_last_query():
   global last_sql_cmd
   return last_sql_cmd

# ------------------------------------------------------------------------------
def f_pgsql_database_error():
   ret_string = "Database error, last request: \"%s\" cannot be fulfilled." % f_pgsql_get_last_query()
   err_msg(ret_string)
   return ret_string

# ------------------------------------------------------------------------------
def f_pgsql_commit():
   db_conn.commit()

# ------------------------------------------------------------------------------
def f_pgsql_rollback():
   db_conn.rollback()

# ------------------------------------------------------------------------------
def f_pgsql_release_database(a_ret_val):
   """ - close database connection - """
   db_cursor.close()
   if a_ret_val != 0:
      f_pgsql_rollback()
   else:
      f_pgsql_commit()
   db_conn.close()

