#coding=utf8

import sys
import os
import re
import math
import string
import time


########################### SETTINGS ###########################################

# - basic setup of whole server -
SERVER_NAME = '' # host name of your machine
SERVER_PORT = '' # port on which to run the server

# - server settings -
DATABASE_NAME = "" # name of DB
DATABASE_USER = "" # DB user
DATABASE_PASSWD = "" # DB password

BASE_DIR = "" # path to "engine" directory
BASE_WEB_DIR = "http://" + SERVER_NAME + "/<YOUR ARBITRARY PATH TO SERVICE>" # server URL

################################################################################

BIN_DIR = BASE_DIR + "/bin"
SRC_DIR = BASE_DIR + "/src"
TMP_DIR = BASE_DIR + "/tmp"
DTD_WEB_DIR = BASE_WEB_DIR + "/dtd"

FRAMES_DIR = BASE_DIR + "/frames"
FRAMES_TO_PROCESS_DIR = FRAMES_DIR + "/to_process"
VIDEOS_DIR = FRAMES_DIR + "/videos"
FRAMES_THUMBS_DIR = FRAMES_DIR + "/thumbs"
VIDEOS_THUMBS_DIR = FRAMES_THUMBS_DIR + "/videos"

# - extension of frames stored in folder FRAMES_DIR -
FRAME_EXT = 'jpg'

# - states of video in database -
VIDEO_state_inserted = 0
VIDEO_state_uploaded = 1
VIDEO_state_in_process = 2
VIDEO_state_processed = 3
VIDEO_state_invalid = 4

VIDEO_state_strings = [
   "inserted",
   "uploaded",
   "in_process",
   "processed",
   "invalid",
]

# - states of image in database -
IMAGE_state_inserted = 0
IMAGE_state_uploaded = 1
IMAGE_state_in_process = 2
IMAGE_state_processed = 3
IMAGE_state_invalid  = 4

IMAGE_state_strings = [
   "inserted",
   "uploaded",
   "in_process",
   "processed",
   "invalid",
]

THUMBNAIL_SIZE = "100x100"

# - exif parsing constants (Czech) -
c_exp_time_exp = "Datum a čas pořízení"
c_exp_lat_dir_exp = "Směr zeměpisné šířky"
c_exp_lat_exp = "Zeměpisná šířka"
c_exp_long_dir_exp = "Směr zeměpisné délky"
c_exp_long_exp = "Zeměpisná délka"

ACCEPTED_VIDEO_FORMATS = (
   "AVI",
   "MPEG",
)

# - global algorithms settings -
SETUP = {

   # - MODULE seg_to_pols -
   "seg_to_pols" : {
      "TRACE_MEDIAN" : 5
   },

   # - MODULE detection -
   "detection" : {
      "CLASSIFIERS_PATH" : BASE_DIR + "/resources/classifiers",
      "CLASSIFIERS_PARAMS" : {
         "car_side"     : "__DEFAULT__",
         "car_back"     : "__DEFAULT__",
         "traffic_sign" : "__DEFAULT__",
         "pedestrian"   : "__DEFAULT__",
      },
   },

   # - MODULE segmentation -
   "segmentation" : {
      "METHOD" : "LBP_0000", 
# "LOCAL_MOMENTS_0000"
# "SPECTRAL_0000",
# "COOCCURENCE_0000"
# "FFT_GABOR_0000"
# "LBP_0000"
      "APPEND_FEATURE" : "position",
      "DISTANCE_METHOD" : "EUCLIDEAN",
# "MANHATTAN"
# "UNIFORM"
# "EUCLIDEAN"
# "MINKOWSKI"
# "LOG_LIKELIHOOD"
      "CENTROID_COUNT" : 10,
      "ITERATION_COUNT" : 200,
   },

   # - MODULE watershed - unused -
   "watershed" : {
      "SEED_PROBABILITY" : 0.00075,
   },

   # - MODULE surface-classification -
   "surface-classification" : {
      "SURFACE-CLASSIFICATION_CONFIG" : BASE_DIR + "/resources/surface-classification/area-types.conf",
   },
}

# ------------------------------------------------------------------------------
def log_msg(a_msg):
   """ print log message """
   print >> sys.stderr, "LOG (%s): %s" % (sys.argv[0],a_msg)
   
# ------------------------------------------------------------------------------
def wrn_msg(a_msg):
   """ print warning message """
   print >> sys.stderr, "WARNING (%s): %s" % (sys.argv[0],a_msg)   

# ------------------------------------------------------------------------------
def err_msg(a_msg):
   """ print error message """
   print >> sys.stderr, "ERROR (%s): %s" % (sys.argv[0],a_msg)

# ------------------------------------------------------------------------------
def f_execute(a_command):
   """ - execute shell command - """
   log_msg("Execute: %s" % a_command)
   return os.system(a_command)

# ------------------------------------------------------------------------------
def f_pipe_execute(a_command):
   """ - execute shell command return stdout file - """
   log_msg("Pipe Execute: %s" % a_command)
   return os.popen(a_command)
   
# ------------------------------------------------------------------------------
def gps_minutes2decimal(a_coords):
   """ - converts GPS coords from [N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss format to (d)dd.dd dd.dd format - """
   gps_check_re = re.compile(r'[N|S]\d{2}\.\d{2}:\d{2}\.\d{2}:\d{2}\.\d{2},[E|W]\d{3}\.\d{2}:\d{2}\.\d{2}:\d{2}\.\d{2}')
   
   re_subs = gps_check_re.findall(a_coords)
   if len(re_subs) != 1 or re_subs[0] != a_coords:
      # wrong format
      return None
   else:
      # correct format, read values of coordinate parts (degrees, minutes, etc.)
      gps_re = re.compile(r'([N|S])(\d{2})\.(\d{2}):(\d{2})\.(\d{2}):(\d{2})\.(\d{2}),([E|W])(\d{3})\.(\d{2}):(\d{2})\.(\d{2}):(\d{2})\.(\d{2})')
      matches = gps_re.match(a_coords)
      
      # --- latitude --- #
      # sign: N +, S -
      lat_sgn = matches.group(1)
      if lat_sgn == 'N':
         lat_sgn = 1
      else:
         lat_sgn = -1
      # degrees
      lat_deg_int  = float(matches.group(2))
      lat_deg_frac = float(matches.group(3))
      # minutes
      lat_min_int  = float(matches.group(4))
      lat_min_frac = float(matches.group(5))
      # seconds
      lat_sec_int  = float(matches.group(6))
      lat_sec_frac = float(matches.group(7))
      
      # --- longitude --- #
      # sign: N +, S -
      lon_sgn = matches.group(8)
      if lon_sgn == 'E':
         lon_sgn = 1
      else:
         lon_sgn = -1
      # degrees
      lon_deg_int  = float(matches.group(9))
      lon_deg_frac = float(matches.group(10))
      # minutes
      lon_min_int  = float(matches.group(11))
      lon_min_frac = float(matches.group(12))
      # seconds
      lon_sec_int  = float(matches.group(13))
      lon_sec_frac = float(matches.group(14))
      
      # conversion
      lat  = (lat_deg_int + lat_deg_frac/100) + (lat_min_int + lat_min_frac/100) / 60 + (lat_sec_int + lat_sec_frac/100) / 3600
      lat *= lat_sgn
      lon  = (lon_deg_int + lon_deg_frac/100) + (lon_min_int + lon_min_frac/100) / 60 + (lon_sec_int + lon_sec_frac/100) / 3600
      lon *= lon_sgn
      
      # assemble the result
      return str(lat) + " " + str(lon)
   

# ------------------------------------------------------------------------------
def gps_decimal2minutes(a_coords):
   """ - converts GPS coords from (d)dd.dd dd.dd format to [N|S]dd.dd:mm.mm:ss.ss [E|W]ddd.dd:mm.mm:ss.ss format- """
   
   coords_check_re = re.compile(r'-?\d+\.\d+ -?\d+\.\d+')
   
   re_subs = coords_check_re.findall(a_coords)
   if len(re_subs) != 1 or re_subs[0] != a_coords:
      # wrong format
      return None
   else:
      # correct format, read values of coordinate parts
      coords_re = re.compile(r'(-?)(\d+)\.(\d+) (-?)(\d+)\.(\d+)')
      matches = coords_re.match(a_coords)
      
      # --- latitude --- #
      # sign: N +, S -
      lat_sgn = matches.group(1)
      if lat_sgn == "-":
         lat_sgn = 'S'
      else:
         lat_sgn = 'N'
      
      lat = float(matches.group(2) + "." +  matches.group(3))
      
      # degrees
      lat_deg_int  = int(math.floor(lat))
      lat -= lat_deg_int
      lat_deg_int = "%02d" % lat_deg_int
      lat_deg_frac = "00"
      # minutes
      lat *= 60
      lat_min_int  = int(math.floor(lat))
      lat -= lat_min_int
      lat_min_int = "%02d" % lat_min_int
      lat_min_frac = "00"
      # minutes
      lat *= 60
      lat_sec_int  = int(math.floor(lat))
      lat -= lat_sec_int
      lat_sec_int = "%02d" % lat_sec_int
      lat_sec_frac = "%02d" % int(str(int(round(lat * 100)))[:2])
      
      res_lat = "%s%s.%s:%s.%s:%s.%s" % (lat_sgn, lat_deg_int, lat_deg_frac, lat_min_int, lat_min_frac, lat_sec_int, lat_sec_frac)
      
      # --- longitude --- #
      # sign: E +, W -
      lon_sgn = matches.group(4)
      if lon_sgn == "-":
         lon_sgn = 'W'
      else:
         lon_sgn = 'E'
      
      lon = float(matches.group(5) + "." +  matches.group(6))
      
      # degrees
      lon_deg_int  = int(math.floor(lon))
      lon -= lon_deg_int
      lon_deg_int = "%03d" % lon_deg_int
      lon_deg_frac = "00"
      # minutes
      lon *= 60
      lon_min_int  = int(math.floor(lon))
      lon -= lon_min_int
      lon_min_int = "%02d" % lon_min_int
      lon_min_frac = "00"
      # minutes
      lon *= 60
      lon_sec_int  = int(math.floor(lon))
      lon -= lon_sec_int
      lon_sec_int = "%02d" % lon_sec_int
      lon_sec_frac = "%02d" % int(str(int(round(lon * 100)))[:2])
      
      res_lon = "%s%s.%s:%s.%s:%s.%s" % (lon_sgn, lon_deg_int, lon_deg_frac, lon_min_int, lon_min_frac, lon_sec_int, lon_sec_frac)

      # assemble the result
      return res_lat + " " + res_lon


# ------------------------------------------------------------------------------
def gps_swap(a_coords, a_sep):
   """ - swaps lat/long in GPS coords separated by the separator - """
   
   if a_coords == None:
      return None
   else:
      parts = a_coords.split(a_sep)
      return parts[1] + a_sep + parts[0]


# ------------------------------------------------------------------------------
def DBout_datetime(db_datetime):
   """ - converts datetime DB format into datetime string format yyyy-mm-dd hh:mm:ss - """
   
   if db_datetime == None:
      return ""
   else:
      return db_datetime


# ------------------------------------------------------------------------------
def DBout_geo_point(db_geo_point):
   """ - converts PostGIS coordinates (string) into GPS location string - """
   """ - POINT(ddd.dddddddd dd.dddddddd) --> [N|S]dd.dd:mm.mm:ss.ss [E|W]ddd.dd:mm.mm:ss.ss - """
   
   if db_geo_point == None:
      return ""
   else:
      geo_point = db_geo_point.strip()
      geo_point = (geo_point[6:])[:-1] # remove "POINT(" and ")" terminators
      geo_point = gps_swap(geo_point, " ") # swap lattitude and longitude, PostGIS uses lon lat ordering
      geo_point = gps_decimal2minutes(geo_point)
      return geo_point


# ------------------------------------------------------------------------------
def DBin_geo_point(geo_point):
   """ - converts GPS location string representation into PostGIS coordinates (string) - """
   """ - [N|S]dd.dd:mm.mm:ss.ss,[E|W]ddd.dd:mm.mm:ss.ss --> POINT(ddd.dddddddd dd.dddddddd) - """
   
   geo_point = gps_minutes2decimal(geo_point)
   geo_point = gps_swap(geo_point, " ") # swap lattitude and longitude, PostGIS uses lon lat ordering
   db_geo_point = "POINT(%s)" % geo_point
   return db_geo_point
