package dtdvalidator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 *
 * @author ilanik
 */
public class DTDValidator {

    private static boolean valid=true;

    /**
     *
     * @param xmlFile xml file
     * @param dtdFile dtd file. File can be null, in this case will be used dtd file from DOCTYPE tag in xml file.
     * @param handler eror and warming handler. Handler can be null.
     * @return true in case xml file is valid otherwise false.
     */
    public static boolean isValid(File xmlFile, File dtdFile,final org.xml.sax.ErrorHandler handler) {

        if (!xmlFile.exists()) {
            return false;
        }

        try {

            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new org.xml.sax.ErrorHandler() {
                //To handle Fatal Errors
                public void fatalError(SAXParseException exception) throws SAXException {
                    if(handler==null){
                        System.out.println("Line: " + exception.getLineNumber() + "\nFatal Error: " + exception.getMessage());
                    }else{
                        handler.fatalError(exception);
                    }
                    valid=false;
                }
                //To handle Errors

                public void error(SAXParseException e) throws SAXException {
                    if(handler==null){
                        System.out.println("Line: " + e.getLineNumber() + "\nError: " + e.getMessage());
                    }else{
                        handler.error(e);
                    }
                     valid=false;
                }
                //To Handle warnings

                public void warning(SAXParseException err) throws SAXException {
                    if(handler==null){
                        System.out.println("Line: " + err.getLineNumber() + "\nWarning: " + err.getMessage());
                    }else{
                        handler.warning(err);
                    }
                     //valid=false;
                }
            });
            Document xmlDocument = builder.parse(new FileInputStream(xmlFile));
            DOMSource source = new DOMSource(xmlDocument);
            
            ByteArrayOutputStream baos=new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if(dtdFile!=null)if (dtdFile.exists()) {
                transformer.setOutputProperty(OutputKeys.DOCTYPE_SYSTEM, dtdFile.getAbsolutePath());
            }
            transformer.transform(source, result);
            return valid;
        } catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }
}
