<?php

//potrebne knihovny

class DBExceptionQueryError extends DBExceptionQueryErrorAbstract
{
	public function __construct($query, $dbResource)
	{
		parent::__construct("Dotaz: ". $query . " vyvolal chybu: ".mysql_error($dbResource), mysql_errno($dbResource));

		$this->errorN = mysql_errno($dbResource);
	}

	public function getNumberError()
	{
		return $this->errorN;
	}

	public function isDuplicateKey()
	{
		return  $this->errorN == 1022;
	}

	public function isTableExist()
	{
		return  $this->errorN == 1050;
	}

	public function isFunctionExist()
	{
		return  $this->errorN == 1125;
	}
}

class DBMySql implements IDBPrototype
{

	/**
	 * posledni dotaz
	 */
	private  $lastQuery;

	/**
	 * zdroj (ukazatel) na otevrenou DB
	 */
	private $dbHandle;

	/**
	 * ulozeny posledni rozparsovany ulozeny dotaz.
	 *
	 * @var unknown_type
	 */
	private $lastParseQuery;


	/* KONSTANTY*/

	public function __construct()
	{
	}


	/**
	 * vytvori objekt a otevre DB
	 *
	 * @param string $dbhost      Jmeno serveru kde bezi MySQL
	 * @param string $dbuser      Jmeno uzivatele serveru
	 * @param string $dbpassword  Heslo k uctu
	 * @param string $dbname      Jmeno database, ktera se ma pouzivat
	 * @param string $character   kodovani v kterem se bude komunikovat ze serverem
	 * @param object $debuglog    debuglog!!!
	 *
	 */
	public  function init($dbhost, $dbuser, $dbpassword, $dbname, $character = "utf8")
	{
		$this->dbHandle = @mysql_pconnect($dbhost, $dbuser, $dbpassword);

		if (!$this->dbHandle)
		throw new DBExceptionNoConnect('Nelze se pripojit k DB serveru');
		$this->dbname = $dbname;

		//@mysql_query("SET NAMES '$character'",$this->dbHandle);
		$this->select($dbname);

		$this->setCharacterResult($character);
	}

	/**
	 * Metoda nastavi kodovani vystupnich dat z dotazu
	 *
	 * @param string $character_set kod kodovani
	 */
	public function setCharacterResult($character_set = 'utf8', $collation = 'utf8_czech_ci')
	{
		if (function_exists('mysql_set_charset'))
		{
			mysql_set_charset($character_set, $this->dbHandle);
		}
		else
		{
			$error = false;
			$error |= !@mysql_query("SET NAMES '$character_set'",$this->dbHandle);
			$error |= !@mysql_query("SET CHARACTER SET $character_set",$this->dbHandle);
			$error |= !@mysql_query("SET CHARACTER SET '$collation'",$this->dbHandle);
			if ($error)
			throw new DBException('No set character result');
		}
	}
	/**
	 * Vybere ze kterou DB se bude pracovat
	 *
	 * @param string $dbName - jmeno databaze
	 */
	public function select($dbName)
	{
		if (mysql_select_db($dbName, $this->dbHandle) === false)
		{
			throw new DBExceptionNoSelect("Nepodarilo se vybrat databazi jmenem \"".$dbName."\"");
		}
	}

	/**
	 * Vyprazdni buffery (Cache)
	 */
	protected function flush()
	{
		$this->last_result = null;
		$this->col_info = null;
		$this->last_query = null;
		$this->num_rows = null;
	}

	/**
	 * metoda vytvori predpripraveny (ulozeny) dotaz. Tj. do dotazu misto hodnot se vklada symbol '?'
	 * po teto metode se provede prikaz execute.
	 *
	 * @var string sql - SQL dotaz kde jsou promnene nahrazeny otaznikem
	 *
	 * @example
	 * <code>
	 * 	$db->prepare("SELECT jmeno, prijmeni, prava FROM uzivatel WHERE id = ?");
	 * </code>
	 *
	 * @param string $query
	 */
	public function prepare($query)
	{
		$this->lastParseQuery = explode('?', $query);
	}

	/**
	 * Metoda vlozi data za otaznik do ulozeneho dotazu a pak tento prikaz provede.
	 * Metoda funguje stejne jako metoda query a vraci i stejny vysledek
	 *
	 * @var list of type parametrs
	 *
	 * @return int pripade dotazu delete|update|insert|replace vrati pocet ovlivnenych radku
	 *             pri selectu vrati pocet vybranych radku
	 */
	public function execute($mixedArray)
	{
		$query = "";
		$count = count($mixedArray);
		$countVars = sizeof($this->lastParseQuery) -1;
		
		if ($count > $countVars)
		{
			throw new DBException("Too much args (".$countVars.'-'.$count.')');
		}
		elseif ($count< $countVars)
		{
			throw new DBException("Too few args");
		}

		for ($i = 0; $i < $countVars; $i++)
		{
			if (is_int($mixedArray[$i]))
			{
				$query .= $this->lastParseQuery[$i] . $mixedArray[$i];
			}
			elseif (is_bool($mixedArray[$i]))
			{
				$query .= $this->lastParseQuery[$i] . ($mixedArray[$i] ? "'1'" : "'0'");
			}
			elseif (is_float($mixedArray[$i]))
			{
				$query .= $this->lastParseQuery[$i] . $mixedArray[$i];
			}
			elseif (is_null($mixedArray[$i]))
			{
				$query .= $this->lastParseQuery[$i] . "NULL";
			}
			elseif (is_object($mixedArray[$i]))
			{
				$query .= $this->lastParseQuery[$i] . "'".serialize($mixedArray[$i])."'";
			}
			else
			$query .= $this->lastParseQuery[$i] . "'". Db::prepareTextToDB($mixedArray[$i]). "'";
		}
		$query .=  $this->lastParseQuery[$i];

		return $this->query($query);
	}


	/**
	 * funkce zpracuje dotaz a ulozi vysledek do Cache
	 *
	 * @param string $query Dotaz ktery chcete provest
	 *
	 * @return int pripade dotazu delete|update|insert|replace vrati pocet ovlivnenych radku
	 *             pri selectu vrati pocet vybranych radku
	 */
	public function query($query)
	{

		//Orezani pro reg. vyrazi
		$query = trim($query);

		// initialise return
		$return_val = 0;

		//Vyprazdneni bufferu
		$this->flush();

		//Ulozni posledniho dotazu
		$this->last_query = $query;

		// Zavolani dotazu
		$this->result = @mysql_query($query, $this->dbHandle);

		// Osetreni chyby, pokud zvnikla
		if ($this->result === false)
		throw new DBExceptionQueryError($query, $this->dbHandle);

		//zpracovavani vysledku dotazu
		// Pokud v dtazu bylo insert, delete, update, replace
		if (preg_match("/^(insert|delete|update|replace)\s+/i", $query))
		{
			$this->rows_affected = mysql_affected_rows();

			// Zjisteni posledniho vlozeneho radku
			if (preg_match("/^(insert|replace)\s+/i", $query))
			{
				$this->insert_id = mysql_insert_id($this->dbHandle);
			}

			//vraceni kolik radku bylo ovlivneno
			$return_val = $this->rows_affected;
		}	//prikazy ktere nic nevraceji
		else if (preg_match("/^(drop|create|start|rollback|commit)\s*/i", $query))
		{

		}
		else //pokud byl zvolen select
		{

			// ulozeni nazvu sloupecku
			$i = 0;
			while ($i < @ mysql_num_fields($this->result))
			{
				$this->col_info[$i] = @ mysql_fetch_field($this->result);
				$i ++;
			}

			// Ulozeni vysledku dotazu
			$num_rows = 0;
			while ($row = @ mysql_fetch_object($this->result))
			{
				// Store relults as an objects within main array
				$this->last_result[$num_rows] = $row;
				$num_rows ++;
			}

			//uvolneni zdroje neni uz potreba
			@mysql_free_result($this->result);

			// ulozeni poctu radku
			$this->num_rows = $num_rows;

			// vraceni kolik bylo ovlivnenych radku
			$return_val = $this->num_rows;
		} //end select
		/*else //ostatni prikazy
		{
		$return_val = mysql_result($this->result, 0);
		}*/

		return $return_val;

	}

	/**
	 * Funkce vrati skalarni (jednu) hodnotu
	 *
	 * @param string $query [nepovynny parametr]Dotaz
	 * @param int $x [default 0] hodnota. cislo sloupce
	 * @param int $y [default 0] hodnota. cislo radku
	 */
	public function getVar($query = null, $x = 0, $y = 0)
	{
		// pokud je zadan i dotaz jinak se pouzijou data v bufferu
		if ($query)
		{
			$this->query($query);
		}

		//Vydolovani dat z vysledku
		if ($this->last_result[$y])
		{
			$values = array_values(get_object_vars($this->last_result[$y]));
		}

		return (isset ($values[$x]) && $values[$x] !== '') ? $values[$x] : null;
	}

	/**
	 * Vrati radek ze zanamu.
	 *
	 * @param string $query [nepovinny parametr] Dotaz
	 * @param const $output [default OBJECT] typ vracenych dat
	 * @param int $y cislo radu ktery se ma vratit
	 *
	 */
	public function getRow($query = null, $output = IDBPrototype::OBJECT, $y = 0)
	{
		// pokud je zadan i dotaz jinak se pouzijou data v bufferu
		if ($query)
		{
			$this->query($query);
		}
			
		//pro objekt
		if ($output == IDBPrototype::OBJECT)
		{
			return $this->last_result[$y] ? $this->last_result[$y] : null;
		}
		//pro asocativni pole
		elseif ($output == IDBPrototype::ARRAY_A)
		{
			return $this->last_result[$y] ? get_object_vars($this->last_result[$y]) : null;
		}
		//pro ciselne pole
		elseif ($output == IDBPrototype::ARRAY_N)
		{
			return $this->last_result[$y] ? array_values(get_object_vars($this->last_result[$y])) : null;
		}
		//pokud je specifikovany chyba
		else
		{
			if (!DEBUGLOGSYS)
			$this->debuglog->addMessage(L_ERROR, "Prikaz get_row ma spatny parametr output");
			else
			trigger_error("Prikaz get_row ma spatny parametr output");
		}

	}

	/**
	 * Vrati sloupec ze zanamu.
	 *
	 * @param string $query [nepovinny parametr] Dotaz
	 * @param int $x cislo slopce ktery se ma vratit
	 *
	 */
	public function getCol($query = null, $x = 0)
	{
		// pokud je zadan i dotaz jinak se pouzijou data v bufferu
		$new_array = array();
		if ($query)
		{
			$this->query($query);
		}

		//naplneni pole
		for ($i = 0; $i < count($this->last_result); $i ++)
		{
			$new_array[$i] = $this->getVar(null, $x, $i);
		}

		return $new_array;
	}

	/**
	 * Vrati vysledek dotazu
	 *
	 * @param string $query [nepovinny parametr] Dotaz
	 * @param const $output [default OBJECT] typ vracenych dat
	 *
	 */
	public function getResults($query = null, $output = IDBPrototype::OBJECT)
	{
		// pokud je zadan i dotaz jinak se pouzijou data v bufferu
		if ($query)
		{
			$this->query($query);
		}

		// vrati jako objekt. kazdy radek je objekt
		if ($output == IDBPrototype::OBJECT)
		{
			return $this->last_result;
		}
		elseif ($output == IDBPrototype::ARRAY_A || $output == IDBPrototype::ARRAY_N)
		{
			if ($this->last_result)
			{
				$i = 0;
				foreach ($this->last_result as $row)
				{

					$new_array[$i] = get_object_vars($row);

					if ($output == IDBPrototype::ARRAY_N)
					{
						$new_array[$i] = array_values($new_array[$i]);
					}

					$i ++;
				}

				return $new_array;
			}
			else
			{
				return null;
			}
		}
	}

	/**
	 * Vrati data z dotazu v podobe objektu ResultSet
	 *
	 * @param enum(ARRAY_A|ARRAY_N) $output typ indexu jakym se budou indexovat jednotlive parametry
	 * 		  (cislem | jmenem)
	 * @return ResultSet Object
	 */
	public function getResulSet($output =  IDBPrototype::ARRAY_A)
	{
		if ($this->last_result)
		{
			$i = 0;
			foreach ($this->last_result as $row)
			{
				$new_array[$i] = get_object_vars($row);

				if ($output == self::ARRAY_N)
				{
					$new_array[$i] = array_values($new_array[$i]);
				}

				$i ++;
			}
			return new ResultSet($new_array);
		}
		else
		{
			return new ResultSet();
		}
	}

	/**
	 * Vrati informace o slopecku
	 *
	 */
	public function getColInfo($info_type = "name", $col_offset = -1)
	{

		if ($this->col_info)
		{
			if ($col_offset == -1)
			{
				$i = 0;
				foreach ($this->col_info as $col)
				{
					$new_array[$i] = $col-> {
						$info_type};
						$i ++;
				}
				return $new_array;
			}
			else
			{
				return $this->col_info[$col_offset]-> {
					$info_type };
			}

		}

	}


	/**
	 * Vrati pocet radku po dotazu select
	 *
	 * @return pocet radku nebo -1
	 */
	public function getNumRows ()
	{
		return (isset($this->num_rows) ? $this->num_rows : -1 );
	}

	/**
	 * Vrati ID posledniho INSERT|REPLACE dotazu
	 *
	 */
	public function getLastID()
	{
		if (isset($this->insert_id))
		return $this->insert_id;
		else
		return false;
	}

	/**

	/**
	* Metoda vrati retezec, tteri identifikuje jmeno driveru
	* @return string
	*
	*/
	public function getDriverName()
	{
		return 'mysql';
	}

	/**
	 * Vrati verzi driveru
	 * @return float
	 */
	public function getVersion()
	{
		return 2.1;
	}

	/**
	 * Zjisti jestli existuje tabulka
	 *
	 * @param string $tableName jmneo tabulky
	 * @return  bool true pokud tabulka existuje
	 */
	public function tableExist($tableName)
	{
		$res = $this->getVar("show tables like '$tableName'");
		return $res == $tableName;
	}

	public function __destruct()
	{
		if (!is_null($this->dbHandle))
		@mysql_close($this->dbHandle);
	}
	
    /**
     * Zacatek transakce (if supported).
     * @return void
     */
    public function begin()
    {
        $this->query('START TRANSACTION');
    }

    /**
     * potvrzeni transakce
     * @return void
     */
    public function commit()
    {
        $this->query('COMMIT');
    }

    /**
     * Zruseni transakce
     * @return void
     */
    public function rollback()
    {
        $this->query('ROLLBACK');
    }
}

?>
