#!/bin/bash

. global.sh

export query=$1
export LD_LIBRARY_PATH=$LSE_BIN_DIR
$LSE_BIN_DIR/LSEsearch_srv \
	-hyps-per-stream       2 \
	-time-delta            5 \
	-fwd-nodes-count       0 \
	-bck-nodes-count       0 \
	-phrase-kwd-neighborhood 0.1 \
	-record-delim          _ \
	-record-cutoff-column  4 \
	-record-channel-column 5 \
	-port                  7777 \
	-results-output-type   xml_transcripts \
	-max-results           1000000 \
	-dont-verify-candidates \
	-charset latin1 \
	-upcase-query \
	-data-dir-path-lvcsr   $INDEXER_DIR/lattices.system.lvcsr \
	-lexicon-idx-lvcsr     $INDEXER_DIR/lexicon/lvcsr/lexicon.IDX \
	-documents-idx-lvcsr   $INDEXER_DIR/idx/_DOCUMENTS.IDX \
	-search-idx-lvcsr      $INDEXER_DIR/idx/lvcsr/_INVSEARCH.IDX \
	-q "&EM=true &FNC=0 &BNC=0 &RES=100000 &SEARCHSOURCETYPE=LVCSR $query" 

#	-g2p-lexicon           /mnt/matylda5/ifapso/exp/std/gptransc/EN/dictionary1.txt \
#	-g2p-rules             /mnt/matylda5/ifapso/exp/std/gptransc/EN/en.fsm \
#	-g2p-symbols           /mnt/matylda5/ifapso/exp/std/gptransc/EN/en.sym \
#	-g2p-max-variants      2 \
#	-g2p-prob-tresh        -1.0 \
