#!/bin/bash

. global.sh

LATTICE_BASE=$1
LATLIST=$2

mkdir -p $INDEXER_DIR/idx/lvcsr/fwd

$LSE_BIN_DIR/LSEindexer  \
	-lat-filename-start-time-field 2  \
	-read-time-from-filename  \
	-latname-time-multiplier 100  \
	-lat-time-multiplier 1 \
	-amscale 1  \
	-lmscale 13  \
	-amscale-kwd 0.00001 \
	-lmscale-kwd 0.00001 \
	-wi-penalty -10 \
	-viterbi-fwbw \
	-compute-links-likelihood \
	-debug-level 0 \
	-lattice-dir-out $INDEXER_DIR/lattices.system.lvcsr \
	-readonly-lexicon \
	-lexicon-in $INDEXER_DIR/lexicon/lvcsr/lexicon.IDX \
	-meeting-indexer-in $INDEXER_DIR/idx/_DOCUMENTS.IDX \
	-search-index $INDEXER_DIR/idx/lvcsr/fwd/_FWDSEARCH_$LATTICE_BASE.IDX \
	-sort-lattice \
	-document-name $LATTICE_BASE \
	-latlist-in $LATLIST

#	-write-viterbi \
#	-write-htk \
#	-concatlattice-out \
